/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/public/dist/js";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./main.js":
/*!*****************!*\
  !*** ./main.js ***!
  \*****************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _src_config_config_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./src/config/config.js */ "./src/config/config.js");
/* harmony import */ var _src_ketchUp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./src/ketchUp.js */ "./src/ketchUp.js");




let loginOverlay = document.getElementById("Registration");
let nextButton = document.getElementById("nextButton");
let introOverlay = document.getElementById("gamestart");
let paytmSuccess = document.getElementById("paytmSuccess");
let howtoPlayLayout = document.getElementById("howToPlay");
let screenLock = document.getElementById("screen-lock");

/** @type {import ("./typings/types")} */

let otpOverlay = document.getElementById("otpOverlay");
let doneButton = document.getElementById("confirmButton");
let startGameBtn = document.getElementById("startGameBtn");
let termAndConditionClick = document.getElementById("termAndConditionClick");
let termAndConditionClick1 = document.getElementById("termAndConditionClick1");
let termAndConditionClick2 = document.getElementById("termAndConditionClick2");
let resendOtp = document.getElementById("resendOtp");
var g_gameServer;
var gameLoaded = false;
var sceneGame;

window.addEventListener('load', (event) => {
    g_gameServer = new GameServer();
    var Phaser = Phaser;
    console.log("screen",screen.orientation.angle);
    if(screen.orientation.angle == 0)
         screenLock.style.display = "block";
    else{
        loadGame();
        gameLoaded = true;
    }

    window.addEventListener("orientationchange", function(event) {
        if(event.target.screen.orientation.angle == 0) {
            otpOverlay.style.display = "block";
            if(sceneGame != undefined) sceneGame.canvas.style.display = "none";
        } else { 
            otpOverlay.style.display = "none";
            screenLock.style.display = "none";  
            if(sceneGame != undefined) sceneGame.canvas.style.display = "block";
            if(gameLoaded == false)   loadGame();
        }
      });
});

function playBgMusic(){
    let bgMusic = new Howl({
        src: "assets/audio/bgnew.mp3",
        loop: true,
        html5: false,
        volume: 0.1,
        onend: function() {
            console.log('Finished!');
        }
    });
    bgMusic.play();
    updateVolume(0.1,bgMusic);
}

nextButton.addEventListener("click", () => {
    playTapSFX();
    var nameValue = document.getElementById("nameInput").value;
    var mobileNumVal =  document.getElementById("mobileNumber").value;
    var checkBox = document.getElementById("mycheck");
    var mobileNumberValid;
    var nameValid;
    var checkBoxValid;
    if(/^\d{10}$/.test(mobileNumVal)) 
        mobileNumberValid = true;
    else{
        mobileNumberValid = false;
        document.getElementById("mobileNumberError").style.display = "block";
    }
    if(nameValue != "")
        nameValid = true;
    else {
        nameValid = false;
        document.getElementById("nameErrorId").style.display = "block";
    }
    if(checkBox.checked == true)
         checkBoxValid = true;
    else {
         checkBoxValid = false;
         document.getElementById("checkBoxerrorId").style.display = "block";
    }
    if(mobileNumberValid && nameValid && checkBoxValid) {
        g_gameServer.createPlayer(nameValue,mobileNumVal)
        hideLoginPage();
        showOtpPage();
    }
});

function hideLoginPage() {
    loginOverlay.style.display = "none";
}

function showLoginPage() {
    loginOverlay.style.display = "block";
}

function showOtpPage() {
    otpOverlay.style.display = "block";
    loginOverlay.style.display = "none";
    setTimeout(function () {
        showResendPwd();
    }, 20000);
}

function showResendPwd() {
    resendOtp.style.display = "block";
}

function hideotpPage() {
    otpOverlay.style.display = "none";
}

// doneButton.addEventListener("click", () => {
//     playTapSFX();
//     var otpEnteredVal =  document.getElementById("otpValue").value;
//     if(otpEnteredVal != ""){
//         g_gameServer.sendOtp(otpEnteredVal);
//     } else{
//         document.getElementById("otpError").style.display = "block";
//     }
// });

startGameBtn.addEventListener("click", () => {
    playTapSFX();
    hideIntroPage();
    loadGame();
});

paytmButton.addEventListener("click", () => {
    playTapSFX();
    var paytmnumberValid;
    var paytmnumber =  document.getElementById("paytmnumberId").value;
    if(/^\d{10}$/.test(paytmnumber)) 
         paytmnumberValid = true;
    else{
        paytmnumberValid = false;
        document.getElementById("mobileNumberId").style.display = "block";
    }
    if(paytmnumberValid){
        document.getElementById("paytmPanel").style.display = "none";
        paytmSuccess.style.display = "block";
        g_gameServer.sendPaytm(paytmnumber);
    }
});

homeButton.addEventListener("click", ()  => {
    playTapSFX();
    refereshPage();
});

// termAndConditionClick.addEventListener("click", () => {
//     openTermsAndConditions();
// });
// termAndConditionClick1.addEventListener("click", () => {
//     openTermsAndConditions();
// });

// resendOtp.addEventListener("click",() => {
//     g_gameServer.resendOtp();
// });

// termAndConditionClick2.addEventListener("click", () => {
//     openTermsAndConditions();
// });


howtoplayClick.addEventListener("click", () => {
    playTapSFX();
    introOverlay.style.display ="none";
    howtoPlayLayout.style.display ="block";

});

backArrowBtn.addEventListener("click", () => {
    playTapSFX();
    introOverlay.style.display ="block";
    howtoPlayLayout.style.display ="none";
});


function refereshPage() {
        localStorage.clear();
        location.reload();
}

function showIntroPage() {
    introOverlay.style.display = "block";
}

function hideIntroPage() {
    introOverlay.style.display = "none";
}

// g_gameServer.sendPaytm("8610201155");

function openTermsAndConditions() {
    var popup = $("#termsAndCondition");
    if (popup.length == 0) {
      $("body").append(TermsAndConditionsHTML);
      popup = $("#termsAndCondition");
      $("#termsAndCondition .closePopup").on("click", function () {
        closeTermsAndConditions();
      });
    }
    $("#termsAndCondition").show();
}

function closeTermsAndConditions() {
    $("#termsAndCondition").hide();
}

function playTapSFX(){
    let sfxEffect = new Howl({
        src: "assets/audio/tap.wav"
    });
    sfxEffect.play();
    updateVolume(2, sfxEffect);
}

function updateVolume(range,sound){
    sound.volume(range);
}

window.checkOtpValidation=function(otpStatus) {
    if(otpStatus != 200){
        document.getElementById("otpError").style.display = "block";
    } else {
          hideotpPage();   
          showIntroPage();
    }
}

function loadGame(){
   sceneGame = new Game();
}

class Game extends Phaser.Game {
	constructor() {
		super(_src_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
		this.scene.add(_src_ketchUp_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
		this.scene.start("ketchUp");
	}
}




/***/ }),

/***/ "./src/config/config.js":
/*!******************************!*\
  !*** ./src/config/config.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scenes/LoadScene.js */ "./src/scenes/LoadScene.js");
/* harmony import */ var _scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scenes/GameScene.js */ "./src/scenes/GameScene.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  type: Phaser.CANVAS,
  parent: "game",
  width: 1280,
  height: 720,
  transparent: true,
  scale: {
    // mode: Phaser.Scale.ENVELOP,
    mode: Phaser.Scale.RESIZE,
    autoCenter: Phaser.Scale.CENTER_BOTH,
    width: 1280,
    height: 720 // orientation: Phaser.Scale.Orientation.LANDSCAPE,

  },
  devicePixelRatio: window.devicePixelRatio,
  scene: [_scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__["default"], _scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__["default"]],
  physics: {
    default: "arcade",
    arcade: {
      gravity: {
        x: 0,
        y: 0
      }
    }
  }
});

/***/ }),

/***/ "./src/ketchUp.js":
/*!************************!*\
  !*** ./src/ketchUp.js ***!
  \************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ketchUp; });
/* harmony import */ var _scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scenes/LoadScene.js */ "./src/scenes/LoadScene.js");
/* harmony import */ var _scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scenes/GameScene.js */ "./src/scenes/GameScene.js");




class ketchUp {
  constructor() {
    this.scene.add(_scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
    this.scene.add(_scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
    this.scene.start("Load");
  }

}

/***/ }),

/***/ "./src/scenes/GameScene.js":
/*!*********************************!*\
  !*** ./src/scenes/GameScene.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _config_config_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../config/config.js */ "./src/config/config.js");

let paytmPanel = document.getElementById("paytmPanel");
let screenLock = document.getElementById("screen-lock");
var tile;

class GameScene extends Phaser.Scene {
  constructor() {
    super("Game");
  }

  init() {}

  preload() {}

  create() {
    // this.scale.lockOrientation("portait")
    this.introScene();
    this.puzzlePiecesArr = ["puzzle1", "puzzle2", "puzzle3", "puzzle4", "puzzle5", "puzzle6", "puzzle7", "puzzle8", "puzzle9"];
    this.tileContainer = [];
    this.totalTilesPlaced = 0;
    var index = 0;
    var initialX = 0.67;
    var initialY = 0.21;
    this.gameOverBool = false;
  }

  introScene() {
    this.gameTotalTime = 60;
    this.bgMainImage = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .5, "gameBg").setScale(.087);
    this.titleJigsaw = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .5, "title").setScale(.05);
    this.logo = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .3, "logo").setScale(.05);
    this.playBtn = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .7, "playBtn").setScale(.07).setInteractive().on('pointerup', () => {
      this.addBGImage();
      this.loadPuzzleImage();
      this.bgMainImage.setAlpha(0);
      this.titleJigsaw.setAlpha(0);
      this.instructionBtn.disableInteractive();
      this.playBtn.disableInteractive();
      this.logo.setAlpha(0);
      this.playBtn.setAlpha(0);
    });
    this.instructionBtn = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .85, "instructionBtn").setScale(.06).setInteractive().on('pointerup', () => {
      this.instructionPageElements();
    });
  }

  instructionPageElements() {
    var initialXTutorial = .25;
    var initialYTutorial = .5;
    var index = 0;
    this.demoTile = [];
    this.overlay = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .5, "ingameBG").setScale(.1).setAlpha(0);
    this.dropareaInstruction = this.add.image(this.cameras.main.width * .23, this.cameras.main.height * .5, "dropArea").setScale(.08).setAlpha(.35).setAlpha(0);
    this.demoTile = this.add.image(this.cameras.main.width * .45, this.cameras.main.height * 1.62, this.puzzlePiecesArr[0]).setScale(0.03);
    this.demoTileOne = this.add.image(this.cameras.main.width * .46, -this.cameras.main.height * .37, this.puzzlePiecesArr[1]).setScale(0.03);
    this.demoTileTwo = this.add.image(this.cameras.main.width * .55, -this.cameras.main.height * .34, this.puzzlePiecesArr[2]).setScale(0.03);
    this.demoTileThree = this.add.image(this.cameras.main.width * .55, this.cameras.main.height * 1.62, this.puzzlePiecesArr[3]).setScale(0.03);
    this.handCursor = this.add.image(this.cameras.main.width * .55, this.cameras.main.height * .67, "handCursor").setScale(.15).setAlpha(0);
    this.InstructionTitle = this.add.text(this.cameras.main.width * .037, this.cameras.main.height * .1, "GAME INSTRUCTIONS").setFontFamily("Arial").setFontSize(30).setColor("#FFFFFF");
    this.stepOne = this.add.text(this.cameras.main.width * .67, this.cameras.main.height * .32, "STEP 1").setFontFamily("Arial").setFontSize(20).setColor("#FFFFFF");
    this.stepOneInstruction = this.add.text(this.cameras.main.width * .67, this.cameras.main.height * .4, "Select the piece to be placed in the puzzle block").setFontFamily("Arial").setFontSize(15).setWordWrapWidth(200).setAlign('left').setColor("#FFFFFF");
    this.stepTwo = this.add.text(this.cameras.main.width * .67, this.cameras.main.height * .54, "STEP 2").setFontFamily("Arial").setFontSize(20).setColor("#FFFFFF");
    this.stepTwoInstruction = this.add.text(this.cameras.main.width * .67, this.cameras.main.height * .61, "Drag and drop the puzzle piece in the correct space").setFontFamily("Arial").setFontSize(15).setWordWrapWidth(200).setAlign('left').setColor("#FFFFFF");

    var _self = this;

    var tweenTutorial = this.tweens.add({
      targets: [this.overlay, this.dropareaInstruction],
      duration: 1500,
      alpha: 1,
      ease: "power",
      onComplete: function () {
        var tweenFall = _self.tweens.add({
          targets: [_self.demoTileOne, _self.demoTileTwo],
          duration: 1500,
          y: _self.cameras.main.height * .36,
          ease: "Power"
        });

        var tweenFall = _self.tweens.add({
          targets: [_self.demoTile, _self.demoTileThree],
          duration: 1500,
          y: _self.cameras.main.height * .55,
          ease: "Power",
          onComplete: function () {
            _self.handCursor.alpha = 1;

            var pathTween = _self.tweens.add({
              targets: _self.demoTileThree,
              duration: 3000,
              y: _self.dropareaInstruction.y,
              x: _self.dropareaInstruction.x,
              ease: "Power"
            });

            var pathTweenHandcursor = _self.tweens.add({
              targets: _self.handCursor,
              duration: 3000,
              y: _self.dropareaInstruction.y + 30,
              x: _self.dropareaInstruction.x,
              ease: "Power"
            });
          }
        });
      }
    });
    this.closeButton = this.add.image(this.cameras.main.width * .95, this.cameras.main.height * .1, "closeButton").setInteractive().on('pointerup', () => {
      var tweenFall = this.tweens.add({
        targets: [this.demoTileOne, this.demoTileTwo, this.overlay, this.dropareaInstruction, this.demoTile, this.demoTileThree, this.handCursor, this.InstructionTitle, this.stepOne, this.stepOneInstruction, this.stepTwo, this.closeButton, this.stepTwoInstruction],
        duration: 1500,
        alpha: 0,
        ease: "Power"
      });
    });
  }

  addBGImage() {
    this.bgImage = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .5, "ingameBG").setScale(.1);
  }

  loadPuzzleImage() {
    this.addTimer();
    this.addDropArea();
    this.addTilePieces();
    this.addHowtoPlayBtn();
    this.addSettingsPlayBtn();
    this.addLogo();
    this.addScoreText();
    this.startTimer();
    this.glow = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .3, "glow").setScale(.25).setAlpha(0);
  }

  addScoreText() {
    this.scoreText = this.add.image(this.cameras.main.width * .75, this.cameras.main.height * .07, "scoreText").setScale(.06);
  }

  addTimer() {
    this.timerTitle = this.add.image(this.cameras.main.width * .06, this.cameras.main.height * .11, "timerText").setScale(.06);
    this.timerBox = this.add.image(this.cameras.main.width * .06, this.cameras.main.height * .22, "timerBox").setScale(.06);
    this.timerTm = this.gameTotalTime + "";
    this.timerText = this.add.text(this.cameras.main.width * .037, this.cameras.main.height * .18, this.timerTm).setFontFamily("Arial").setFontSize(30).setColor("#FFFFFF");
  }

  startTimer() {
    var self = this;
    this.timedEvent = setInterval(function () {
      self.gameTotalTime -= 1; // One second

      let remainingTime = self.runTimer(self.gameTotalTime);
      self.timerText.setText(remainingTime);

      if (self.gameTotalTime === 0) {
        self.totalTilesPlaced = 0;
        self.gameOverBool = false;
        clearInterval(self.timedEvent);
        self.gameOver();
      }
    }, 1000);
  }

  gameOver() {
    this.overlay = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .5, "ingameBG").setScale(.1).setAlpha(1);
    this.timesUpText = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .45, "timeup").setScale(.05);
    this.howToplayImg.disableInteractive();
    this.gameTotalTime = 60;
    this.dummyBtn.disableInteractive();
    this.retryBtn = this.add.image(this.cameras.main.width * .25, this.cameras.main.height * .8, "retryBtn").setScale(.08).setInteractive().on('pointerdown', () => {
      this.loadLevel();
    });
    this.homeBtn = this.add.image(this.cameras.main.width * .75, this.cameras.main.height * .8, "homeBtn").setScale(.08).setInteractive().on('pointerdown', () => {
      this.loadHomePage();
    });

    for (let i = 0; i < this.tileContainer.length; i++) {
      this.tileContainer[i].destroy();
      this.tileContainer[i].setAlpha(0);
    }
  }

  loadLevel() {
    this.loadPuzzleImage();
    this.homeBtn.setAlpha(0);
    this.retryBtn.setAlpha(0);
    this.homeBtn.disableInteractive();
    this.retryBtn.disableInteractive();
    this.timesUpText.setAlpha(0);
    this.overlay.setAlpha(0);
  }

  loadHomePage() {
    this.homeBtn.setAlpha(0);
    this.retryBtn.setAlpha(0);
    this.homeBtn.disableInteractive();
    this.retryBtn.disableInteractive();
    this.timesUpText.setAlpha(0);
    this.overlay.setAlpha(0);
    this.introScene(); // this.introScene.setAlpha(0);
  }

  runTimer(gameTime) {
    return gameTime--;
  }

  addHowtoPlayBtn() {
    this.howToplayImg = this.add.image(this.cameras.main.width * .06, this.cameras.main.height * .38, "howtoPlay").setScale(.09).setInteractive().on("pointerdown", () => {
      this.instructionPageElements();
    });
    this.howToPlayText = this.add.image(this.cameras.main.width * .06, this.cameras.main.height * .48, "howtoplayText").setScale(.09);
  }

  addSettingsPlayBtn() {
    this.settingsImg = this.add.image(this.cameras.main.width * .06, this.cameras.main.height * .58, "settingsIcon").setScale(.09);
    this.settingsText = this.add.image(this.cameras.main.width * .06, this.cameras.main.height * .68, "settingsText").setScale(.09);
  }

  addLogo() {
    this.ingameLogo = this.add.image(this.cameras.main.width * .06, this.cameras.main.height * .78, "logo").setScale(.06);
    this.ogImg = this.add.image(this.cameras.main.width * .4, this.cameras.main.height * .5, "ogImg").setScale(.06).setAlpha(0);
    this.dummyBtn = this.add.image(this.cameras.main.width * .15, this.cameras.main.height * .1, "viewpicture").setScale(.13).setInteractive().on('pointerdown', () => {
      if (this.ogImg.alpha == 1) this.playFadeOut();else this.playFadeIn();
    });
    ;
  }

  playFadeOut() {
    var tween = this.tweens.add({
      targets: this.ogImg,
      duration: 1500,
      alpha: 0,
      ease: "Bounce.Out"
    });
  }

  playFadeIn() {
    var tween = this.tweens.add({
      targets: this.ogImg,
      duration: 1500,
      alpha: 1,
      ease: "Bounce.Out"
    });
  }

  addDropArea() {
    // this.lights.enable().setAmbientColor(0x333333);
    this.dropArea = this.add.image(this.cameras.main.width * .38, this.cameras.main.height * .53, "dropArea").setScale(.08).setAlpha(.35);
    this.dropBounds = this.dropArea.getBounds(); // console.log("this.dropBounds",this.dropBounds)
    // console.log("this.dropAreaWidth",this.dropArea.width);
    //console.log("this.dropAreaX",this.dropArea.x+this.dropArea.width/2);
    // this.light1 = this.lights.addLight(180, 80, 200).setColor(0x0000FF).setIntensity(2);
  }

  addTilePieces() {
    var index = 0;
    var initialX = 0.67;
    var initialY = 0.21;

    var _self = this;

    for (let i = 0; i < 3; i++) {
      for (var j = 0; j < 3; j++) {
        this.tile = this.physics.add.sprite(this.cameras.main.width * initialX, this.cameras.main.height * initialY, this.puzzlePiecesArr[index]).setScale(0.05).setInteractive({
          draggable: true
        }).setAlpha(0.8);
        this.tile.tag = index;
        this.tileContainer.push(this.tile);
        this.tile.startposX = this.cameras.main.width * initialX;
        this.tile.startposY = this.cameras.main.height * initialY;
        this.assignPosition(index, this.tile);
        this.input.setDraggable(this.tile);
        this.tile.input.draggable = true;
        initialX += 0.12;
        index++;
      }

      initialX = 0.7;
      initialY += 0.3;
    }

    this.input.on('dragstart', function (pointer, gameObject) {
      _self.children.bringToTop(gameObject);

      _self.alterOrigin(gameObject);
    });
    this.input.on('drag', function (pointer, gameObject, dragX, dragY) {
      gameObject.x = dragX;
      gameObject.y = dragY;
    });
    this.input.on('dragend', function (pointer, gameObject) {
      if (gameObject.x > _self.dropBounds.left && gameObject.x <= _self.dropBounds.right && gameObject.y < _self.dropBounds.bottom && gameObject.y > _self.dropBounds.top) {
        _self.checkSuccessfullDrop(gameObject.tag, gameObject);
      } else {
        gameObject.x = gameObject.startposX;
        gameObject.y = gameObject.startposY;
        gameObject.setOrigin(0.5, 0.5);
      }
    });
  }

  update() {
    console.log("this.totalTilesPlaced", this.totalTilesPlaced);

    if (this.totalTilesPlaced == 9) {
      if (this.gameOverBool === false) {
        this.gameOverBool = true;
        this.triggerGameOver();
      }
    }
  }

  triggerGameOver() {
    this.overlay = this.add.image(this.cameras.main.width * 6.5, this.cameras.main.height * .5, "ingameBG").setScale(.1);
    this.gameOverTitle = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .4, "success").setScale(.06).setAlpha(0);
    this.cashback = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .6, "cashback").setScale(.03).setAlpha(0);
    clearInterval(this.timedEvent);
    var self = this;
    var twenOverlay = this.tweens.add({
      targets: this.overlay,
      x: this.cameras.main.width * .5,
      duration: 5000,
      ease: "power",
      onComplete: function () {
        var tweenTitle = self.tweens.add({
          targets: [self.gameOverTitle, self.cashback],
          alpha: 1,
          duration: 3000,
          ease: "power",
          onComplete: function () {
            var tweencash = self.tweens.add({
              targets: self.cashback,
              scale: 0.07,
              duration: 3000,
              yoyo: true,
              ease: "power",
              onComplete: function () {
                self.playEmitterEffect();
              }
            });
          }
        });
      }
    });
    clearInterval(this.timedEvent);
  }

  checkSuccessfullDrop(index, gameObject) {
    if (gameObject.correctDropX - 4 < gameObject.x && gameObject.x < gameObject.correctDropX + 4) {
      if (gameObject.correctDropY - 4 < gameObject.y && gameObject.y < gameObject.correctDropY + 4) {
        gameObject.x = gameObject.correctDropX;
        gameObject.y = gameObject.correctDropY;
        gameObject.disableInteractive();
        gameObject.setAlpha(1);
        gameObject.setTint(0xFFD700);

        if (gameObject.dropSuccess == false) {
          this.totalTilesPlaced++;
          gameObject.dropSuccess = true;
        }
      } else {
        gameObject.x = gameObject.x;
        gameObject.y = gameObject.y;
      }
    } else {
      gameObject.x = gameObject.x;
      gameObject.y = gameObject.y;
    }
  }

  dropObject(gameObject) {
    gameObject.x = gameObject.correctDropX;
    gameObject.y = gameObject.correctDropY;
    gameObject.disableInteractive();
  }

  assignPosition(group, tile) {
    this.dropBounds = this.dropArea.getBounds();

    switch (group) {
      case 0:
        tile.correctDropX = this.dropBounds.right - 7;
        tile.correctDropY = this.dropBounds.bottom - 6;
        tile.dropSuccess = false; // tile.setOrigin(1,1)

        break;

      case 1:
        tile.correctDropX = this.dropBounds.centerX;
        tile.correctDropY = this.dropBounds.centerY + 7;
        tile.dropSuccess = false; // tile.setOrigin(0.5,0.5);

        break;

      case 2:
        tile.correctDropX = this.dropBounds.left + 7;
        tile.correctDropY = this.dropBounds.bottom - 5;
        tile.dropSuccess = false; // tile.setOrigin(0,1);

        break;

      case 3:
        tile.correctDropX = this.dropBounds.right - 36;
        tile.correctDropY = this.dropBounds.top + 14;
        tile.dropSuccess = false; // tile.setOrigin(0.5,0);

        break;

      case 4:
        tile.correctDropX = this.dropBounds.left + 7;
        tile.correctDropY = this.dropBounds.top + 14;
        tile.dropSuccess = false; // tile.setOrigin(0,0);

        break;

      case 5:
        tile.correctDropX = this.dropBounds.centerX + 8;
        tile.correctDropY = this.dropBounds.top + 14;
        tile.dropSuccess = false; // tile.setOrigin(0.5,0);

        break;

      case 6:
        tile.correctDropX = this.dropBounds.right - 36;
        tile.correctDropY = this.dropBounds.centerY + 14;
        tile.dropSuccess = false; // tile.setOrigin(0.5,0.5);

        break;

      case 7:
        tile.correctDropX = this.dropBounds.centerX - 8;
        tile.correctDropY = this.dropBounds.bottom - 6;
        tile.dropSuccess = false; // tile.setOrigin(0.5,1);

        break;

      case 8:
        tile.correctDropX = this.dropBounds.left + 7;
        tile.correctDropY = this.dropBounds.centerY - 3;
        tile.dropSuccess = false; // tile.setOrigin(0,0.5);  

        break;
    }
  }

  alterOrigin(gameObject) {
    switch (gameObject.tag) {
      case 0:
        gameObject.setOrigin(1, 1);
        break;

      case 1:
        gameObject.setOrigin(0.5, 0.5);
        break;

      case 2:
        gameObject.setOrigin(0, 1);
        break;

      case 3:
        gameObject.setOrigin(0.5, 0);
        break;

      case 4:
        gameObject.setOrigin(0, 0);
        break;

      case 5:
        gameObject.setOrigin(0.5, 0);
        break;

      case 6:
        gameObject.setOrigin(0.5, 0.5);
        break;

      case 7:
        gameObject.setOrigin(0.5, 1);
        break;

      case 8:
        gameObject.setOrigin(0, 0.5);
        break;
    }
  }

  playEmitterEffect() {
    let particles100 = this.add.particles('rupee');
    let particles500 = this.add.particles('500');
    this.emitter100 = particles100.createEmitter({
      x: this.cameras.main.width * .5,
      y: 0,
      quantity: {
        min: 4,
        max: 20
      },
      frequency: 500,
      angle: {
        min: 180,
        max: 360
      },
      rotate: {
        min: 0,
        max: 300
      },
      speed: 200,
      gravityY: 500,
      scale: {
        min: 0.01,
        max: 0.02
      },
      lifespan: 10000,
      particleClass: Phaser.GameObjects.Particles.Particle
    });
    this.emitter500 = particles500.createEmitter({
      x: this.cameras.main.width * .5,
      y: 0,
      quantity: {
        min: 4,
        max: 20
      },
      frequency: 1000,
      angle: {
        min: 180,
        max: 360
      },
      rotate: {
        min: 0,
        max: 300
      },
      speed: 200,
      gravityY: 500,
      scale: {
        min: 0.001,
        max: 0.009
      },
      lifespan: 10000,
      particleClass: Phaser.GameObjects.Particles.Particle
    });
    this.time.delayedCall(10000, () => {
      this.emitter100.stop();
      this.emitter500.stop();
      this.playHomeButtonHover();
    });
  }

  playHomeButtonHover() {
    this.homeBtnGameOver = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .8, "homeBtn").setScale(.08).setInteractive().on('pointerdown', () => {
      this.loadHomePageFromGameOver();
    });
    var tweenPlayBtn = this.tweens.add({
      targets: this.homeBtnGameOver,
      scale: 0.09,
      yoyo: true,
      loop: true,
      ease: "power"
    });
  }

  loadHomePageFromGameOver() {
    this.gameTotalTime = 60;
    this.totalTilesPlaced = 0;
    this.gameOverBool = false;
    this.howToplayImg.disableInteractive();
    this.dummyBtn.disableInteractive();
    this.homeBtnGameOver.destroy();
    this.overlay.destroy();
    this.gameOverTitle.destroy();
    this.cashback.destroy();
    this.introScene();
  }

}

/* harmony default export */ __webpack_exports__["default"] = (GameScene);

/***/ }),

/***/ "./src/scenes/LoadScene.js":
/*!*********************************!*\
  !*** ./src/scenes/LoadScene.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _config_config_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../config/config.js */ "./src/config/config.js");


class LoadScene extends Phaser.Scene {
  constructor() {
    super("Load");
  }

  preload() {
    console.log("--- LOAD PRELOAD ---", this); // //PROGRESS BAR

    let progressBar = this.add.graphics();
    let progressBox = this.add.graphics();
    progressBox.fillStyle(0x222222, 0.8);
    progressBox.fillRect(250, 215, 320, 50); //LOADING TEXT
    // let loadingText = this.make.text({
    // 	x: 450,
    // 	y: 200,
    // 	text: "Loading...",
    // 	style: {
    // 		font: "20px monospace",
    // 		fill: "#ffffff",
    // 	},
    // });
    // loadingText.setOrigin(1, 1);
    //PERCENT TEXT

    let percentText = this.make.text({
      x: 400,
      y: 225,
      text: "0%",
      style: {
        font: "18px monospace",
        fill: "#ffffff"
      }
    }); //percentText.setOrigin(1, 1);
    // load assets declared in the preload config

    this.loadImages();
    this.loadAudio();
    this.loadAnimations();
    this.loadComplete = false;
    this.load.on("progress", function (value) {
      progressBar.clear();
      progressBar.fillStyle(0xffffff, 1);
      progressBar.fillRect(260, 223, 300 * value, 30);
      percentText.setText(parseInt(value * 100) + " %");
    });
    this.load.on("fileprogress", function (file) {});
    this.loadComplete = false;
    this.load.on("complete", function () {
      progressBar.destroy();
      progressBox.destroy(); // loadingText.destroy();

      percentText.destroy();
      this.loadComplete = true;
    });
  }

  create() {
    this.scene.start("Game");
  }

  loadAnimations() {}

  loadImages() {
    this.load.image("playBtn", "assets/img/jigsaw/play.png");
    this.load.image("glow", "assets/img/jigsaw/glow.png");
    this.load.image("instructionBtn", "assets/img/jigsaw/instruction.png");
    this.load.image("howtoPlay", "assets/img/jigsaw/howtoplayicon.png");
    this.load.image("howtoplayText", "assets/img/jigsaw/howtoplaytext.png");
    this.load.image("timerText", "assets/img/jigsaw/time.png");
    this.load.image("scoreText", "assets/img/jigsaw/score.png");
    this.load.image("settingsIcon", "assets/img/jigsaw/settingicon.png");
    this.load.image("settingsText", "assets/img/jigsaw/settingtext.png"); //Jigsaw puzzle gamet

    this.load.image("gameBg", "assets/img/jigsaw/Puzzleconcept.jpg");
    this.load.image("ingameBG", "assets/img/jigsaw/ingamebg.jpg");
    this.load.image("title", "assets/img/jigsaw/title.png");
    this.load.image("logo", "assets/img/jigsaw/logo.png");
    this.load.image("puzzle1", "assets/img/jigsaw/puzzle1.png");
    this.load.image("puzzle2", "assets/img/jigsaw/puzzle2.png");
    this.load.image("puzzle3", "assets/img/jigsaw/puzzle3.png");
    this.load.image("puzzle4", "assets/img/jigsaw/puzzle4.png");
    this.load.image("puzzle5", "assets/img/jigsaw/puzzle5.png");
    this.load.image("puzzle6", "assets/img/jigsaw/puzzle6.png");
    this.load.image("puzzle7", "assets/img/jigsaw/puzzle7.png");
    this.load.image("puzzle8", "assets/img/jigsaw/puzzle8.png");
    this.load.image("puzzle9", "assets/img/jigsaw/puzzle9.png"); // this.load.image("dropArea", "assets/img/jigsaw/droparea.png");

    this.load.image('dropArea', 'assets/img/jigsaw/dropareanew.png');
    this.load.image("timerBox", "assets/img/jigsaw/timerBox.png");
    this.load.image("logo", "assets/img/jigsaw/logo.png");
    this.load.image("dummyBtn", "assets/img/jigsaw/dummyImg.png");
    this.load.image("ogImg", "assets/img/jigsaw/ogImg.jpg");
    this.load.image("viewpicture", "assets/img/jigsaw/viewpicture.png");
    this.load.image("handCursor", "assets/img/jigsaw/hand.png");
    this.load.image("closeButton", "assets/img/jigsaw/closebtn.png");
    this.load.image("timeup", "assets/img/jigsaw/timeup.png");
    this.load.image("homeBtn", "assets/img/jigsaw/home.png");
    this.load.image("retryBtn", "assets/img/jigsaw/retry.png");
    this.load.image("success", "assets/img/jigsaw/hereis.png");
    this.load.image("cashback", "assets/img/jigsaw/20.png");
    this.load.image("rupee", "assets/img/jigsaw/rupee.png");
    this.load.image("500", 'assets/img/jigsaw/500.png');
  }

  loadAudio() {// this.load.audio("shakeAudio", "assets/audio/bottleShake.wav");
    // this.load.audio("squeeze","assets/audio/squeeze.wav");
    // this.load.audio("dummyAudio", "assets/audio/Generic_Coach_Tip.mp3");
  }

}

/* harmony default export */ __webpack_exports__["default"] = (LoadScene);

/***/ }),

/***/ 0:
/*!***********************!*\
  !*** multi ./main.js ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /Users/sindujarajadurai/Desktop/soccerDemo/main.js */"./main.js");


/***/ })

/******/ });
//# sourceMappingURL=app.bundle.js.map