import config from "../config/config.js";
let paytmPanel = document.getElementById("paytmPanel");
let screenLock = document.getElementById("screen-lock");
var tile;

class GameScene extends Phaser.Scene {
    constructor() {
        super("Game");
    }
    init() {
    }

    preload() {
    }

    create() {
        // this.scale.lockOrientation("portait")
        this.introScene();
        this.puzzlePiecesArr = ["puzzle1","puzzle2", "puzzle3","puzzle4","puzzle5","puzzle6","puzzle7","puzzle8","puzzle9"];
        this.tileContainer  = [];
        this.totalTilesPlaced = 0;
        var index = 0;
        var initialX =  0.67;
        var initialY =  0.21;
        this.gameOverBool = false;
        this.totalScore = 0;
    }

    introScene(){
        this.totalScore = 0;
        this.gameTotalTime = 120;
        this.bgMainImage = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .5,"gameBg").setScale(0.5)
        this.titleJigsaw = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .5, "title").setScale(.05);
        this.logo = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .3, "logo").setScale(.07);
        this.playBtn = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .7, "playBtn").setScale(.35).setInteractive().on('pointerup',  () => {
                this.addBGImage();
                this.loadPuzzleImage();
                this.bgMainImage.setAlpha(0);
                this.titleJigsaw.setAlpha(0);
                this.instructionBtn.disableInteractive();
                this.playBtn.disableInteractive();
                this.logo.setAlpha(0);
                this.playBtn.setAlpha(0);
                this.toggleFullScreen();
        });
        this.instructionBtn = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .85, "instructionBtn").setScale(.06).setInteractive().on('pointerup', () => {
            this.instructionPageElements();
        });
    }

    toggleFullScreen(){
        if (!document.fullscreenElement) {
            document.documentElement.requestFullscreen();
        } else {
          if (document.exitFullscreen) {
            document.exitFullscreen();
          }
        }
    }

    instructionPageElements() {
        this.instructionBtn.disableInteractive();
        var initialXTutorial = .25;
        var initialYTutorial = .5;
        var index = 0;
        this.demoTile = [];
        this.overlay = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .5,"ingameBG").setAlpha(0).setScale(.5);
        this.dropareaInstruction = this.add.image(this.cameras.main.width * .3, this.cameras.main.height * .4,"dropArea").setScale(.08).setAlpha(.15).setAlpha(0);

        this.demoTile = this.add.image(this.cameras.main.width * .65,this.cameras.main.height * 1.62, this.puzzlePiecesArr[0]).setScale(0.03);
        this.demoTileOne = this.add.image(this.cameras.main.width * .65,-this.cameras.main.height * .37, this.puzzlePiecesArr[1]).setScale(0.03);
        this.demoTileTwo = this.add.image(this.cameras.main.width * .85,-this.cameras.main.height * .34, this.puzzlePiecesArr[2]).setScale(0.03);
        this.demoTileThree = this.add.image(this.cameras.main.width * .85,this.cameras.main.height * 1.62, this.puzzlePiecesArr[3]).setScale(0.03);

        this.handCursor = this.add.image(this.cameras.main.width * .85, this.cameras.main.height * .51,"handCursor").setScale(.15).setAlpha(0);

        this.InstructionTitle = this.add.text(this.cameras.main.width * .03 ,this.cameras.main.height * .1, "GAME INSTRUCTIONS")
        .setFontFamily("Georgia")
        .setFontSize(30)
        .setColor("#FFFFFF");

        this.stepOne = this.add.text(this.cameras.main.width * .07, this.cameras.main.height * .6, "STEP 1")
        .setFontFamily("Arial")
        .setFontSize(20)
        .setColor("#FFFFFF");

        this.stepOneInstruction = this.add.text(this.cameras.main.width * .07, this.cameras.main.height * .64, "Drag and Drop the Puzzle pieces to build the Engine.")
        .setFontFamily("Georgia")
        .setFontSize(15)
         .setWordWrapWidth(300)
        .setAlign('left')
        .setColor("#FFFFFF");

        this.stepTwo = this.add.text(this.cameras.main.width * .07, this.cameras.main.height * .72, "STEP 2")
        .setFontFamily("Arial")
        .setFontSize(20)
        .setColor("#FFFFFF");

        this.stepTwoInstruction = this.add.text(this.cameras.main.width * .07, this.cameras.main.height * .76, "Place the puzzle pieces inside the purple grid and get Cashback")
        .setFontFamily("Georgia")
        .setFontSize(15)
        .setWordWrapWidth(300)
        .setAlign('left')
        .setColor("#FFFFFF");

        this.stepThree = this.add.text(this.cameras.main.width * .07, this.cameras.main.height * .84, "STEP 3")
        .setFontFamily("Arial")
        .setFontSize(20)
        .setColor("#FFFFFF");

        this.stepThreeInstruction = this.add.text(this.cameras.main.width * .07, this.cameras.main.height * .88, "You will have 120 seconds to finish building the Engine")
        .setFontFamily("Georgia")
        .setFontSize(15)
         .setWordWrapWidth(300)
        .setAlign('left')
        .setColor("#FFFFFF");

        this.instructionConatiner = this.add.container([this.overlay,this.dropareaInstruction,this.stepOneInstruction,
                                                        this.demoTile,this.demoTileOne,this.demoTileTwo,this.demoTileThree,
                                                        this.handCursor,this.InstructionTitle,this.stepOne,this.stepTwo,
                                                        this.stepTwoInstruction,this.stepThree,this.stepThreeInstruction])

        var _self = this;

        var tweenTutorial = this.tweens.add({
			targets: [this.overlay,this.dropareaInstruction],
            duration: 1500,
            alpha: 1,
            ease: "power",
            onComplete: function () {
                var tweenFall = _self.tweens.add({
                    targets : [_self.demoTileOne,_self.demoTileTwo],
                    duration: 1500,
                    y:_self.cameras.main.height * .33,
                    ease: "Power"
                });

                var tweenFall = _self.tweens.add({
                    targets : [_self.demoTile,_self.demoTileThree],
                    duration: 1500,
                    y:_self.cameras.main.height * .47,
                    ease: "Power",
                    onComplete: function () {
                        _self.handCursor.alpha = 1;
                        var pathTween = _self.tweens.add({
                            targets :_self.demoTileThree,
                            duration: 3000,
                            y:_self.dropareaInstruction.y,
                            x:_self.dropareaInstruction.x,
                            ease:"Power"
                        });
                        var pathTweenHandcursor = _self.tweens.add({
                            targets :_self.handCursor,
                            duration: 3000,
                            y:_self.dropareaInstruction.y + 30,
                            x:_self.dropareaInstruction.x,
                            ease:"Power",
                            onComplete: function () {
                                _self.addCloseBtn();
                            }
                        });
                    }
                });
           }
        }); 
    }

    addCloseBtn() {
        this.closeButton = this.add.image(this.cameras.main.width * .9,this.cameras.main.height * .05,"closeButton").setInteractive().on('pointerdown',  () => {
            this.instructionConatiner.destroy();
            this.instructionBtn.setInteractive();
            var tweenFall = this.tweens.add({
                targets : [this.demoTileOne,this.demoTileTwo,this.overlay,
                            this.dropareaInstruction,this.demoTile,
                            this.demoTileThree,this.handCursor,this.InstructionTitle,
                            this.stepOne,this.stepOneInstruction,this.stepTwo,this.closeButton,this.stepTwoInstruction,this.stepThree,this.stepThreeInstruction],
                duration: 500,
                alpha:0,
                ease: "Power"
            });
     });
    }

    addBGImage() {
        this.bgImage = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .5,"ingameBG").setScale(.5);
    }

    loadPuzzleImage() {
        this.addTimer();
        this.addDropArea();
        this.addTilePieces();
        this.addHowtoPlayBtn();
        this.addSettingsPlayBtn();
        this.addLogo();
        this.addScoreText();
        this.startTimer();
        this.glow = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .3, "glow").setScale(.01).setAlpha(0);
    }

    addScoreText() {
        this.scoreText = this.add.image(this.cameras.main.width * .8, this.cameras.main.height * .08, "scoreText").setScale(.06);
        this.currentScore =  "0" + this.totalScore;
        this.score = this.add.text(this.cameras.main.width * .88, this.cameras.main.height * .06, this.currentScore)
        .setFontFamily("Arial")
        .setFontSize(25)
        .setColor("#FFFFFF")
    }

    addTimer(){
        this.timerTitle = this.add.image(this.cameras.main.width * .08,this.cameras.main.height * .08, "timerText").setScale(.06);
        this.timerBox = this.add.image(this.cameras.main.width * .22, this.cameras.main.height * .08, "timerBox").setScale(.06);
        this.timerTm = this.gameTotalTime + "";
        this.timerText = this.add.text(this.cameras.main.width * .18,this.cameras.main.height * .06, this.timerTm)
        .setFontFamily("Arial")
        .setFontSize(30)
        .setColor("#FFFFFF")
    }

    startTimer() {
        var self = this;
        this.timedEvent = setInterval(function () {
            self.gameTotalTime -= 1; // One second
            let remainingTime = self.runTimer(self.gameTotalTime);
            self.timerText.setText(remainingTime);
            if (self.gameTotalTime === 0) {
                self.totalTilesPlaced = 0;
                self.gameOverBool = false;
                clearInterval(self.timedEvent);
                self.gameOver();
             }
          }, 1000);
    }

    gameOver() {
        this.overlay = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .5,"ingameBG").setAlpha(1).setScale(.5);
        this.timesUpText = this.add.image(this.cameras.main.width *.5,this.cameras.main.height * .3,"timeup").setScale(.05);
        this.howToplayImg.disableInteractive();
        this.gameTotalTime = 120;
        this.totalScore = 0;
        this.dummyBtn.disableInteractive();
        this.retryBtn = this.add.image(this.cameras.main.width * 2.5, this.cameras.main.height * .6,"retryBtn").setScale(.35).setInteractive().on('pointerdown', () => {
            this.loadLevel();
        });
        var retryTween = this.tweens.add({
            targets :this.retryBtn,
            duration: 3000,
            x:this.cameras.main.width * .5,
            ease:"Sine.Out"
        });

        this.homeBtn = this.add.image(this.cameras.main.width * -1.5, this.cameras.main.height * .8,"homeBtn").setScale(.35).setInteractive().on('pointerdown', () => {
            this.loadHomePage();
        });

        var homeTween = this.tweens.add({
            targets :this.homeBtn,
            duration: 3000,
            x:this.cameras.main.width * .5,
            ease:"Sine.Out"
        });
        // this.retryBtn = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .6,"retryBtn").setScale(.08).setInteractive().on('pointerdown', () => {
        //     this.loadLevel();
        // });
        // this.homeBtn = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .8,"homeBtn").setScale(.08).setInteractive().on('pointerdown', () => {
        //     this.loadHomePage();
        // });
        for(let i=0;i<this.tileContainer.length;i++){
            this.tileContainer[i].destroy();
            this.tileContainer[i].setAlpha(0);
        }
    }

    loadLevel() {
                this.loadPuzzleImage();
                this.homeBtn.setAlpha(0);
                this.retryBtn.setAlpha(0);
                this.homeBtn.disableInteractive();
                this.retryBtn.disableInteractive();
                this.timesUpText.setAlpha(0);
                this.overlay.setAlpha(0);
    }

    loadHomePage(){
        this.homeBtn.setAlpha(0);
        this.retryBtn.setAlpha(0);
        this.homeBtn.disableInteractive();
        this.retryBtn.disableInteractive();
        this.timesUpText.setAlpha(0);
        this.overlay.setAlpha(0);
        this.introScene();
        // this.introScene.setAlpha(0);
    }

    runTimer(gameTime) {
        return gameTime--;
    }

    addHowtoPlayBtn() {
        this.howToplayImg = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .9,"howtoPlay").setScale(.09).setInteractive().on("pointerdown", () => {
            this.instructionPageElements();
        });
        this.howToPlayText = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .96,"howtoplayText").setScale(.09);
    }

    addSettingsPlayBtn() {
        this.settingsImg = this.add.image(this.cameras.main.width * .7, this.cameras.main.height * .9,"settingsIcon").setScale(.09);
        this.settingsText = this.add.image(this.cameras.main.width * .7,this.cameras.main.height * .96,"settingsText").setScale(.09);
    }

    addLogo() {
         this.ingameLogo = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .09, "logo").setScale(.06);
         this.ogImg = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .32,"ogImg").setAlpha(0).setScale(0.25);
         //setScale(.055)
         this.dummyBtn = this.add.image(this.cameras.main.width * .3, this.cameras.main.height * .9, "viewpicture").setScale(.13).setInteractive().on('pointerdown',  () => {
             if(this.ogImg.alpha == 1)
                this.playFadeOut();
             else 
                this.playFadeIn();
        });;
    }

    playFadeOut(){
        var tween = this.tweens.add({
			targets: this.ogImg,
            duration: 1500,
            alpha: 0,
			ease: "Bounce.Out"
        }); 
    }

    playFadeIn() {
        var tween = this.tweens.add({
			targets: this.ogImg,
            duration: 1500,
            alpha: 1,
			ease: "Bounce.Out"
        }); 
        this.children.bringToTop(this.ogImg);
    }

    addDropArea() {
        // this.lights.enable().setAmbientColor(0x333333);
        var scalingFactor = .08;
        this.dropArea = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .32,"dropArea").setAlpha(.35);
        this.dropArea.setScale(scalingFactor).setOrigin(0.5);
        this.dropBounds = this.dropArea.getBounds();
        var rectWidth = this.dropArea.width * scalingFactor /3;
        var rectHeight = this.dropArea.height * scalingFactor /3;
	    this.rectWidth = rectWidth;
	    this.rectHeight = rectHeight;

        //this.graphics = this.add.graphics({ lineStyle: { width: 2, color: 0x00ff00 }, fillStyle: { color: 0xff0000 }});
        //this.r1 = new Phaser.Geom.Rectangle(this.dropBounds.left, this.dropBounds.top, rectWidth, rectHeight);
        //this.graphics.lineStyle(2, 0x1a65ac);
        //this.graphics.strokeRectShape(this.r1);
        this.r1 =  this.add.rectangle(this.dropBounds.left, this.dropBounds.top, rectWidth, rectHeight).setOrigin(0,0);
        this.r1.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);

        //this.r1.setStrokeStyle(2, 0x1a65ac).setAlpha(.5).setOrigin(0,0);
        this.r2 = this.add.rectangle(this.dropArea.x, this.dropBounds.top, rectWidth, rectHeight).setOrigin(0.5,0);
        this.r2.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);
        this.r3 = this.add.rectangle(this.dropBounds.right, this.dropBounds.top, rectWidth, rectHeight).setOrigin(1,0);
        this.r3.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);

        this.r4 = this.add.rectangle(this.dropBounds.left, this.dropArea.y, rectWidth, rectHeight).setOrigin(0,0.5);
        this.r4.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);

        this.r5 = this.add.rectangle(this.dropArea.x, this.dropArea.y, rectWidth, rectHeight);
        this.r5.setStrokeStyle(3, 0x1a65ac).setAlpha(.5).setOrigin(0.5,0.5);

        this.r6 = this.add.rectangle(this.dropBounds.right, this.dropArea.y, rectWidth, rectHeight).setOrigin(1,0.5);
        this.r6.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);

        this.r7 = this.add.rectangle(this.dropBounds.left, this.dropBounds.bottom, rectWidth, rectHeight).setOrigin(0,1);
        this.r7.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);
        this.r8 = this.add.rectangle(this.dropArea.x, this.dropBounds.bottom, rectWidth, rectHeight).setOrigin(0.5,1);
        this.r8.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);
        this.r9 = this.add.rectangle(this.dropBounds.right, this.dropBounds.bottom, rectWidth, rectHeight).setOrigin(1,1);
        this.r9.setStrokeStyle(3, 0x1a65ac).setAlpha(.5);

        //console.log("this.dropBounds",this.dropBounds)
        //console.log("this.dropAreaWidth",this.dropArea.width);
        //console.log("this.dropAreaX",this.dropArea.x+this.dropArea.width/2);
        //this.light1 = this.lights.addLight(180, 80, 200).setColor(0x0000FF).setIntensity(2);
    }

    addTilePieces() {
        var index = 0;
        var initialX =  0.27;
        var initialY =  0.55;
        var _self = this;
        for(let i=0;i<3;i++){
            for(var j=0;j<3;j++){
                this.tile = this.physics.add.sprite(this.cameras.main.width * initialX,this.cameras.main.height * initialY,this.puzzlePiecesArr[index]).setScale(0.05).setInteractive({ draggable: true }).setAlpha(0.8);
                this.tile.tag = index;
                this.tileContainer.push(this.tile);
                this.tile.startposX = this.cameras.main.width * initialX;
                this.tile.startposY = this.cameras.main.height * initialY;
                this.assignPosition(index,this.tile);
                this.input.setDraggable(this.tile);
                this.tile.input.draggable = true;
                initialX += 0.21;
                index++;
            }
            initialX = 0.27;
            initialY += 0.12;
        }
        this.input.on('dragstart', function (pointer, gameObject) {
          //gameObject.setDepth(50);
           _self.children.bringToTop(gameObject)
           _self.alterOrigin(gameObject);
        });

        this.input.on('drag', function (pointer, gameObject, dragX, dragY) {
            gameObject.x = dragX;
            gameObject.y = dragY;
        });

       this.input.on('dragend', function (pointer, gameObject) {
       if(gameObject.x > _self.dropBounds.left && gameObject.x <= _self.dropBounds.right && gameObject.y < _self.dropBounds.bottom && gameObject.y > _self.dropBounds.top){
            _self.checkSuccessfullDrop(gameObject.tag,gameObject)
        } else {
            gameObject.x = gameObject.startposX;
            gameObject.y = gameObject.startposY;
            gameObject.setOrigin(0.5,0.5);
        }
      });
    }

    update() {
        //console.log("this.totalTilesPlaced",this.totalTilesPlaced)
        if(this.totalTilesPlaced == 9) {
            if(this.gameOverBool === false) {
                this.gameOverBool = true;
                this.triggerOgImage();
                // this.triggerGameOver();
            }
        }
    }

    triggerOgImage() {
            var _self = this;
            _self.ogImg.setScale(0);
            clearInterval(this.timedEvent);
            _self.ogImg.alpha = 1;
            _self.children.bringToTop(_self.ogImg);
            var tweenOgImage = _self.tweens.add({
                targets:_self.ogImg,
                scale: .25,
                duration: 1000,
                ease: "power",
                delay: 2000,
                onComplete: function() {
                    var tweenOgImage = _self.tweens.add({
                        targets:_self.ogImg,
                        scale: 0,
                        duration: 700,
                        ease: "power",
                        delay: 2000,
                        onComplete: function() {
                            _self.triggerGameOver();
                        }
                })
            }
            });
      }

    triggerGameOver() {
        this.overlay = this.add.image(this.cameras.main.width * 6.5,this.cameras.main.height * .5,"ingameBG").setScale(.5);
        this.gameOverTitle = this.add.image(this.cameras.main.width *.5,this.cameras.main.height * .4,"success").setScale(.06).setAlpha(0).setDepth(1000);
        this.cashback = this.add.image(this.cameras.main.width *.5,this.cameras.main.height * .6 ,"cashback").setScale(.03).setAlpha(0).setDepth(1000);;
        clearInterval(this.timedEvent);
        var self = this;
        var twenOverlay = this.tweens.add({
             targets:this.overlay,
             x:this.cameras.main.width * .5,
             duration: 2000,
             ease: "power",
             onComplete: function () {
                //console.log("self.gameOverTitle",self.gameOverTitle);
                //console.log("self.cashback",self.cashback);
                 var tweenTitle = self.tweens.add({
                    targets:[self.gameOverTitle,self.cashback],
                    alpha:1,
                    duration: 3000,
                    ease: "power",
                    onComplete: function () {
                        var tweencash = self.tweens.add({
                            targets:self.cashback,
                            scale:0.07,
                            duration: 500,
                            yoyo:true,
                            ease: "power",
                            onComplete: function () {
                                 self.playHomeButtonHover();
                               // self.playEmitterEffect();
                            }
                        })
                    }
                 })
             }
         });
         clearInterval(this.timedEvent);
    }

    checkSuccessfullDrop(index,gameObject) {
       // console.log("gameObject.correctRectangle",gameObject.correctRectangle.top,gameObject.correctRectangle.bottom,gameObject.y);
        if(gameObject.correctRectangle.left < gameObject.x && gameObject.x < gameObject.correctRectangle.right){
            if(gameObject.correctRectangle.top < gameObject.y && gameObject.y < gameObject.correctRectangle.bottom) {
            //gameObject.setOrigin(0.5,0.5);
                gameObject.x = gameObject.correctDropX;
                gameObject.y = gameObject.correctDropY;
                gameObject.setScale(gameObject.dropXScale,gameObject.dropYScale);
                gameObject.disableInteractive();
            if(gameObject.dropSuccess == false) {
                this.totalTilesPlaced++;
                gameObject.dropSuccess = true;
                this.updateScore(gameObject);
            }
        } else {
            console.log("yWrong");
            gameObject.x = gameObject.x;
            gameObject.y = gameObject.y;
            this.outerRect.setStrokeStyle(6,0xff0000);
            var _self = this;
	        navigator.vibrate(300);
            var tweenGlow = this.tweens.add({
                targets:  this.outerRect,
                alpha: 1,
                yoyo:true,
                onComplete: function() {
                   _self.outerRect.alpha=0;
                }
            });
        }
      } else {
            gameObject.x = gameObject.x;
            gameObject.y = gameObject.y;
            this.outerRect.setStrokeStyle(6,0xff0000);
            var _self = this;
	        navigator.vibrate(300);
            var tweenGlow = this.tweens.add({
                targets:  this.outerRect,
                alpha: 1,
                yoyo:true,
                onComplete: function() {
                   _self.outerRect.alpha=0;
                }
            });
        }
    }

    updateScore(gameObject){
        this.totalScore++;
        this.currentScore = "0" + this.totalScore;
        this.score.setText(this.currentScore);
        this.playGlowTween(gameObject);
    }

    playGlowTween(gameObject){
	var _self = this;
    _self.outerRect.setStrokeStyle(6,0x32CD32)
        var tweenGlow = this.tweens.add({
            targets:  this.outerRect,
            alpha: 1,
            yoyo:true,
            onComplete: function() {
               _self.outerRect.alpha=0;
            }
    });


        // this.glow.setOrigin(gameObject.originX,gameObject.originY);
        // this.glow.setPosition(gameObject.x,gameObject.y);
        // this.children.bringToTop(this.glow);

        // var self = this;
        // this.glow.setAlpha(1);
        // this.children.bringToTop(this.glow)
        // var tweenGlow = this.tweens.add({
        //     targets: this.glow,
        //     scale: .02,
        //     yoyo:true,
        //     onComplete: function() {
        //         self.glow.alpha = 0;
        //     }
        // });

    }

    dropObject(gameObject){
         gameObject.x = gameObject.correctDropX;
         gameObject.y = gameObject.correctDropY;
         gameObject.disableInteractive();
	    
    }

    assignPosition(group,tile){
	this.outerRect = this.add.rectangle(this.dropBounds.left,this.dropBounds.top,this.rectWidth*3,this.rectHeight*3).setOrigin(0,0).setAlpha(0);
    	this.dropBounds  = this.dropArea.getBounds();
    switch(group) {
        case 0:
            tile.dropSuccess = false;
            tile.correctDropX = this.r9.x - 1.6;
            tile.correctDropY = this.r9.y - 1.4;
            tile.correctRectangle = this.r9.getBounds();
	        console.log("r9");
            tile.dropXScale = 0.055;
            tile.dropYScale = 0.059;
            break;
        case 1:
            tile.dropSuccess = false;
            tile.correctDropX = this.r5.x;
            tile.correctDropY = this.r5.y+.5;
            tile.dropXScale = 0.05;
            tile.dropYScale = 0.05;
            tile.correctRectangle = this.r5.getBounds();
            break;
        case 2:
            //4,3.5
            tile.dropSuccess = false;
            tile.correctDropX = this.r7.x + 2.5;
            tile.correctDropY = this.r7.y - 2.2;
            tile.dropXScale = 0.057;
            tile.dropYScale = 0.058;
            tile.correctRectangle = this.r7.getBounds();
            break;
        case 3:
            tile.correctDropX = this.r3.x - 34;
            tile.correctDropY = this.r3.y + 2;
            tile.correctRectangle = this.r3.getBounds();
            tile.dropXScale = 0.058;
            tile.dropYScale = 0.056;
            tile.dropSuccess = false;
            break;
        case 4:
            //3.9- x
            //3.6 -y
            //2.9
            tile.correctDropX = this.r1.x + 2.5;
            tile.correctDropY = this.r1.y + 2.2;
            tile.correctRectangle = this.r1.getBounds();
            tile.dropXScale = 0.055;
            tile.dropYScale = 0.055;
            tile.dropSuccess = false;
            break;
        case 5:
            tile.correctDropX = this.r2.x + 8.9;
            tile.correctDropY = this.r2.y + 2.4;
            tile.correctRectangle = this.r2.getBounds();
            tile.dropXScale = 0.05;
            tile.dropYScale = 0.053;
            tile.dropSuccess = false;
            break;
        case 6:
            tile.correctDropX = this.r6.x - 33;
            tile.correctDropY = this.r6.y + 9;
            tile.correctRectangle = this.r6.getBounds();
            tile.dropXScale = 0.058;
            tile.dropYScale = 0.051;
            tile.dropSuccess = false;
            break;
        case 7:
            //3 -y
            //8.57
            tile.correctDropX = this.r8.x - 8.8;
            tile.correctDropY = this.r8.y - 2;
            tile.correctRectangle = this.r8.getBounds();
            tile.dropXScale = 0.05;
            tile.dropYScale = 0.058;
            tile.dropSuccess = false;
            break;
        case 8:
            //3.9
            tile.correctDropX = this.r4.x + 2.5;
            tile.correctDropY = this.r4.y - 9;
            tile.correctRectangle = this.r4.getBounds();
            tile.dropXScale = 0.06;
            tile.dropYScale = 0.05;
            tile.dropSuccess = false;
            break;
    }
}

    alterOrigin(gameObject) {
        switch(gameObject.tag) { 
            case 0:
                gameObject.setOrigin(1,1);
                break;
            case 1:
                gameObject.setOrigin(0.5,0.5);
                break;
            case 2:
                gameObject.setOrigin(0,1);
                break;
            case 3:
                gameObject.setOrigin(0.5,0);
                break;
            case 4:
                gameObject.setOrigin(0,0);
                break;
            case 5:
                gameObject.setOrigin(0.5,0);
                break;
            case 6:
                gameObject.setOrigin(0.5,0.5);
                break;
            case 7:
                gameObject.setOrigin(0.5,1);
                break;
            case 8:
                gameObject.setOrigin(0,0.5);  
                break;
        }
    }

    playEmitterEffect() {
    let particles100 = this.add.particles('rupee');
    let particles500 = this.add.particles('500');

    this.emitter100 = particles100.createEmitter({
        x: this.cameras.main.width * .5,
        y: 0,
        quantity: {min:4, max: 20},
        frequency: 500,
        angle: { min: 180, max: 360 },
        rotate: { min: 0, max: 300},
        speed: 200,
        gravityY:500,
        scale: { min : 0.01, max: 0.02},
        lifespan: 10000,
        particleClass: Phaser.GameObjects.Particles.Particle
    });

    this.emitter500 = particles500.createEmitter({
        x: this.cameras.main.width * .5,
        y: 0,
        quantity: {min:4, max: 20},
        frequency: 1000,
        angle: { min: 180, max: 360 },
        rotate: { min: 0, max: 300},
        speed: 200,
        gravityY:500,
        scale: { min : 0.001, max: 0.009},
        lifespan: 10000,
        particleClass: Phaser.GameObjects.Particles.Particle
    });

    this.time.delayedCall(10000, ()=>{
        this.emitter100.stop();
        this.emitter500.stop();
        this.playHomeButtonHover();
     });
    }

    playHomeButtonHover(){
        this.homeBtnGameOver = this.add.image(this.cameras.main.width * .5,this.cameras.main.height * .8, "homeBtn").setScale(.35).setInteractive().on('pointerdown', () => {
            this.loadHomePageFromGameOver();
        });
       var tweenPlayBtn = this.tweens.add({
           targets:this.homeBtnGameOver,
           scale: 0.3,
           yoyo: true,
           repeat: -1,
           ease: "power"
       });
    }

    loadHomePageFromGameOver() {
        this.gameTotalTime = 120;
        this.totalTilesPlaced = 0;
        this.totalScore = 0;
        this.gameOverBool = false;
        this.howToplayImg.disableInteractive();
        this.dummyBtn.disableInteractive();
        this.homeBtnGameOver.destroy();
        this.overlay.destroy();
        this.gameOverTitle.destroy();
        this.cashback.destroy();
        this.introScene();
    }
}

export default GameScene;