import config from "../config/config.js";

class LoadScene extends Phaser.Scene {

	constructor() {
		super("Load");
	}

	preload() {
			console.log("--- LOAD PRELOAD ---");
	
			// load assets declared in the preload config
			this.loadImages();
			this.loadAudio();
			this.loadAnimations();
			//PROGRESS BAR
		let progressBar = this.add.graphics();
		let progressBox = this.add.graphics();
		progressBox.fillStyle(0x222222, 0.8);
		progressBox.fillRect(
			config.width / 2 - 150,
			config.height / 2 - 30,
			320,
			50
		);

		//LOADING TEXT
		let loadingText = this.make.text({
			x: config.width / 2,
			y: config.height / 2 - 50,
			text: "Loading...",
			style: {
				font: "20px monospace",
				fill: "#ffffff",
			},
		});
		loadingText.setOrigin(0.5, 0.5);

		//PERCENT TEXT
		let percentText = this.make.text({
			x: config.width / 2,
			y: config.height / 2 - 5,
			text: "0%",
			style: {
				font: "18px monospace",
				fill: "#ffffff",
			},
		});
		percentText.setOrigin(0.5, 0.5);

		this.load.on("progress", function (value) {
			progressBar.clear();
			progressBar.fillStyle(0xffffff, 1);
			progressBar.fillRect(
				config.width / 2 - 140,
				config.height / 2 - 20,
				300 * value,
				30
			);
			percentText.setText(parseInt(value * 100) + " %");
		});

		this.load.on("fileprogress", function (file) {});

		this.loadComplete = false;
		this.load.on("complete", function () {
			progressBar.destroy();
			progressBox.destroy();
			loadingText.destroy();
			percentText.destroy();
			this.loadComplete = true;
		});
	
		}

	create() {
		this.scene.start("Game");
	}

	loadAnimations() {
	}

	loadImages(){
		this.load.image("playBtn","assets/img/jigsaw/play_dum.png");
		this.load.image("glow", "assets/img/jigsaw/glow.png");
		this.load.image("instructionBtn", "assets/img/jigsaw/instruction.png");
		this.load.image("howtoPlay", "assets/img/jigsaw/howtoplayicon.png");
		this.load.image("howtoplayText","assets/img/jigsaw/howtoplaytext.png");
		this.load.image("timerText", "assets/img/jigsaw/time.png");
		this.load.image("scoreText", "assets/img/jigsaw/score.png");

		this.load.image("settingsIcon","assets/img/jigsaw/settingicon.png");
		this.load.image("settingsText","assets/img/jigsaw/settingtext.png");
		
		//Jigsaw puzzle gamet
		this.load.image("gameBg", "assets/img/jigsaw/Puzzleconcept.jpg");
		this.load.image("ingameBG", "assets/img/jigsaw/ingamebg.jpg");
		this.load.image("title",  "assets/img/jigsaw/title.png");
		this.load.image("logo",   "assets/img/jigsaw/logo.png");
		this.load.image("puzzle1", "assets/img/jigsaw/puzzle1.png");
		this.load.image("puzzle2", "assets/img/jigsaw/puzzle2.png");
		this.load.image("puzzle3", "assets/img/jigsaw/puzzle3.png");
		this.load.image("puzzle4", "assets/img/jigsaw/puzzle4.png");
		this.load.image("puzzle5", "assets/img/jigsaw/puzzle5.png");
		this.load.image("puzzle6", "assets/img/jigsaw/puzzle6.png");
		this.load.image("puzzle7", "assets/img/jigsaw/puzzle7.png");
		this.load.image("puzzle8", "assets/img/jigsaw/puzzle8.png");
		this.load.image("puzzle9", "assets/img/jigsaw/puzzle9.png");

		// this.load.image("dropArea", "assets/img/jigsaw/droparea.png");
		this.load.image('dropArea', 'assets/img/jigsaw/dropareanew.png');
		this.load.image("timerBox", "assets/img/jigsaw/timerBox.png");
		this.load.image("logo", "assets/img/jigsaw/logo.png");
		// this.load.image("dummyBtn", "assets/img/jigsaw/dummyImg.png");
		this.load.image("ogImg", "assets/img/jigsaw/ogImg.png");

		this.load.image("viewpicture", "assets/img/jigsaw/viewpicture.png");

		this.load.image("handCursor","assets/img/jigsaw/hand.png");
		this.load.image("closeButton", "assets/img/jigsaw/closebtn.png");
		this.load.image("timeup", "assets/img/jigsaw/timeup.png");

		this.load.image("homeBtn","assets/img/jigsaw/home_dum.png");
		this.load.image("retryBtn", "assets/img/jigsaw/retry_dum.png");

		this.load.image("success","assets/img/jigsaw/hereis.png");
		this.load.image("cashback","assets/img/jigsaw/20.png");
		this.load.image("rupee","assets/img/jigsaw/rupee.png");
	//	this.load.image("500", 'assets/img/jigsaw/500.png');
	}

	loadAudio(){
		// this.load.audio("shakeAudio", "assets/audio/bottleShake.wav");
		// this.load.audio("squeeze","assets/audio/squeeze.wav");
		// this.load.audio("dummyAudio", "assets/audio/Generic_Coach_Tip.mp3");
	}

}

export default LoadScene;




