
export default class Pickable extends Phaser.GameObjects.Sprite {

    constructor(scene,xPos,yPos,spriteStr) {
        super(scene,xPos,yPos,spriteStr);
        scene.add.existing(this);
		this.setScrollFactor(0);
       // this.getQuestionArray();
    }

    setProperties() {
        this.handleInputEvents();
    }

    getQuestionArray() {
        this.questionX = this.scene.getxPos();
        this.questionY = this.scene.getyPos();
		this.localDrag = false;
    }

	resetScrolling() {

	}

	setDragProperty() {
		this.setInteractive({ draggable: true });
	}

	handleInputEvents() {
		var _self = this;
		this.scene.input.on('dragstart', function (pointer, gameObject) {
			_self.scene.children.bringToTop(gameObject);
			_self.fadeOutPosmBoard();
			console.log("gameObjectKey",gameObject)
			_self.scene.placeObject(gameObject.key+1,gameObject)
			_self.scene.insideContainer = false;
			_self.scene.falseDrop = false;
		});

		this.scene.input.on('drag', function (pointer, gameObject, dragX, dragY) {
			gameObject.x = dragX;
			gameObject.y = dragY;
		});

		this.scene.input.on('dragend', function (pointer, gameObject) {
			console.warn("dragENd")
			var tempX;
			_self.fadeInPosmBoard();
			if(_self.scene.panningActivated == true) {
				tempX = gameObject.x;
				gameObject.x = gameObject.x +_self.scene.cameras.main.width/2;
			}
			for (let i = 0; i < _self.scene.questionImgArr.length; i++) {
				var overlapValue = _self.scene.checkOverlap(gameObject, _self.scene.questionImgArr[i]);
				if (overlapValue.x !== 0 && overlapValue.y !== 0) {
					if(_self.scene.insideContainer == false) {
					_self.scene.insideContainer = true;
					_self.scene.triggerSucessfulldrop(gameObject, _self.scene.questionImgArr[i], i,tempX);
					}
				} else {
					_self.scene.falseDrop = true;
				}
			}
			if (_self.scene.falseDrop == true && _self.scene.insideContainer == false) {
				gameObject.x = _self.scene.cameras.main.width * .89;
				gameObject.y = _self.scene.posmBoard.y + 10;
				gameObject.setInteractive();
			}
		});
	}

	fadeOutPosmBoard() {
		var fadeOut= this.scene.tweens.add({
			targets: this.scene.posmBoard,
			duration: FADE_TWEEN_DURATION,
			alpha: 0,
			ease: 'Sine.easeInOut',
			callback: function () {
			}
		});
	}


	fadeInPosmBoard() {
		var fadeIn= this.scene.tweens.add({
			targets: this.scene.posmBoard,
			duration: FADE_TWEEN_DURATION,
			alpha: 0.7,
			ease: 'Sine.easeInOut',
			callback: function () {
			}
		});
	}

}