import IntroText from "../UIpanel/Introtext.js";

class uiIntro extends Phaser.GameObjects.Container {

	constructor(scene, x, y) {
		
		super(scene, 0, 0);
		this.scene = scene;
		this.scene.add.existing(this);
		this.loadIntroScene();
		this.animations  = [];

	}

	loadIntroScene() {
		this.loadBg = this.scene.add.image(this.scene.cameras.main.width * .5, this.scene.cameras.main.height * .5, g_assetsKeyJSON.LOADBG)
			.setOrigin(0.5)
			.setScale(1.3);
		this.dialogbox = this.scene.add.image(this.scene.cameras.main.width * .35, this.scene.cameras.main.height * .6, g_assetsKeyJSON.DIALOGBOX)
			.setScale(0).setOrigin(0.5).setScale(1.3);
		
		this.scene.addCashierAnimation();
		this.speechBubbleScaleup();
	}

	speechBubbleScaleup() {
		var _self = this;
		var  tweenBtn = this.scene.tweens.add({
			targets: this.dialogbox,
		 	duration: 500,
		 	x: this.scene.cameras.main.width * .55,
			y: this.scene.cameras.main.height * .3,
			scaleX: 1.1,
			scaleY:0.8,
		 	ease: "Power",
			onComplete: function() {
				_self.dialogText();
				_self.nextBtn = _self.scene.add.image(_self.scene.cameras.main.width * .88, _self.scene.cameras.main.height * .8,g_assetsKeyJSON.RIGHTARROW).setScale(.25).setInteractive().on('pointerdown', () => {
					_self.nextBtn.disableInteractive();
					_self.nextBtn.alpha = 0;
					_self.introDialog.alpha = 0;
					_self.introDialog2.alpha = 0;
					_self.tweenDialogPanel();
				 });;	
				 _self.scene.arrowTween(_self.nextBtn);
			}
		 });
	}

	tweenDialogPanel() {
		this.dialogStr = "";
	//	this.dialog.alpha = 0;
		var _self = this;
		var  tweenBtn = this.scene.tweens.add({
			targets: this.dialogbox,
		 	duration: 500,
		 	x: this.scene.cameras.main.width * .35,
			y: this.scene.cameras.main.height * .6,
			scale: 0,
		 	ease: "Power",
			onComplete: function() {
				 _self.tweenInDialog();
				 _self.scene.toggleFullScreen();

			}
		 });
	}

	tweenInDialog(){
		var _self = this;
		var  tweenBtn = _self.scene.tweens.add({
			targets: _self.dialogbox,
		 	duration: 500,
			 x: this.scene.cameras.main.width * .55,
			 y: this.scene.cameras.main.height * .3,
			 scaleX: 1.1,
			 scaleY:0.8,
		 	ease: "Power",
			onComplete: function() {
				_self.introDialog2.setPosition(_self.introDialog2.x,_self.scene.cameras.main.height * .24);
				_self.introDialog2.setText(SECONDARY_STR[0])
				_self.dialog.setText(SECONDARY_STR[1]);
				_self.dialog.setPosition(_self.dialog.x,_self.scene.cameras.main.height * .3);
				_self.introDialog2.alpha = 1;
				_self.dialog.alpha = 1;
				_self.hintBtn();
			}
		 });
	}

	hintBtn() {
		this.hint= this.scene.add.image(this.scene.cameras.main.width * .6, this.scene.cameras.main.height * .75,g_assetsKeyJSON.HINT).setScale(.6).setInteractive().on('pointerdown', () => {
			this.hint.disableInteractive();
			this.hint.alpha = 0.3;
			this.addOutputScreen();
		 });;
		 this.animateHintBtn();
	}

	animateHintBtn() {
		var _self = this;
			var fadeInText = _self.scene.tweens.add({
				targets: _self.hint,
				scale: 0.5,
				duration: BLINK_DURATION,
				yoyo: true,
				repeat: -1,
				ease: "power",
				callback: function () {
				}
			});
	}

	addOutputScreen() {
		var _self = this;
		 this.outputImg = this.scene.add.image(this.scene.cameras.main.width * .5,this.scene.cameras.main.height * .5,g_assetsKeyJSON.DUMMYBG).setScale(0).setDepth(2000);
		    var tweenOutput = this.scene.tweens.add({
			targets: this.outputImg,
		 	duration: FADE_TWEEN_DURATION,
		 	scaleX: 0.9,
			scaleY: 0.42,
		 	ease: "Power",
			onComplete: function() {
			  _self.closeBtn = _self.scene.add.image(_self.scene.cameras.main.width * .9,_self.scene.cameras.main.height * .8,g_assetsKeyJSON.RIGHTARROW).setScale(0.2).setDepth(2200).setScrollFactor(0).setInteractive().on('pointerdown', () => {
				_self.fadeOutputScreen();
			  var cameraOutputPan =  _self.scene.cameras.main.pan(0, 0, 3000, 'Sine.easeInOut', false);
			  _self.closeBtn.disableInteractive();
			  _self.closeBtn.destroy();
				_self.shelfOne.destroy();
				_self.lipton.destroy();
				_self.shelftwo.destroy();
			});  
			    _self.arrowTween();
				_self.nextBtn.destroy();
				_self.dialogbox.destroy();
				_self.dialog.destroy();
				_self.hint.destroy();
				_self.dialogText.alpha = 0;
				_self.introDialog2.alpha = 0;
				_self.loadPOSMElements();
			    _self.addDialogBox();
				_self.scene.cashier.setAlpha(1)

			}
		 });
	}

	arrowTween() {
		var tweenArrow = this.scene.tweens.add({
			targets: this.closeBtn,
			scale: .3,
			yoyo: true,
			loop: -1,
			duration: TINT_DURATION,
			ease: "Sine.easeInOut",
			callback: function () {
			}
		});
	}

	createAnims() {

		var nachos = this.scene.anims.create({
			key: 'nachosAnim',
			frames: [
				{ key: g_assetsKeyJSON.NACHOS},
				{ key: g_assetsKeyJSON.NACHOSG}
			],
			frameRate: 3,
			repeat: -1
		});

		var milo = this.scene.anims.create({
			key: 'miloAnim',
			frames: [
				{ key: g_assetsKeyJSON.MILO},
				{ key: g_assetsKeyJSON.MILOG}
			],
			frameRate: 2,
			repeat: -1
		});

		var dairyMilk = this.scene.anims.create({
			key: 'dairyAnim',
			frames: [
				{ key: g_assetsKeyJSON.DAIRYMILK_S},
				{ key: g_assetsKeyJSON.DAIRYMILKG }
			],
			frameRate: 2,
			repeat: -1
		});

		var kitkat = this.scene.anims.create({
			key: 'kitkatAnim',
			frames: [
				{ key: g_assetsKeyJSON.PHILIPS},
				{ key: g_assetsKeyJSON.KITKATG}
			],
			frameRate: 3,
			repeat: -1
		});

		var maggie = this.scene.anims.create({
			key: 'maggieAnim',
			frames: [
				{ key: g_assetsKeyJSON.REDEEM},
				{ key: g_assetsKeyJSON.REDEEMG }
			],
			frameRate: 2,
			repeat: -1
		});
		this.animations.push("nachosAnim","miloAnim","dairyAnim","kitkatAnim","maggieAnim")
		
	}

	loadPOSMElements() {

		this.scene.cameras.main.setBounds(0, 0, 2048, 1024);

		this.questionX = [this.scene.cameras.main.width * .55, this.scene.cameras.main.width * .71,this.scene.cameras.main.width * 1.18,
			this.scene.cameras.main.width * .22, this.scene.cameras.main.width * .2];

		this.questionY = [this.scene.cameras.main.height * .15, this.scene.cameras.main.height * .55, this.scene.cameras.main.height * .62,
			this.scene.cameras.main.height * .64, this.scene.cameras.main.height * .32];
		
		this.itemsStrArr = ITEM_DEMO;
		this.posmElementsArr =[];


		this.createAnims();

		for(let i = 0;i< this.itemsStrArr.length;i++) {
			var gameObject = this.scene.add.sprite(this.questionX[i], this.questionY[i],this.itemsStrArr[i]).play(this.animations[i]).setDepth(2000);
			this.posmElementsArr.push(gameObject);
			switch(i+1) {
			case 1:
				gameObject.setScale(.35);
			break;
			case 2:
				gameObject.setScale(.25);
			break;
			case 3:
				gameObject.setScale(.5);
			break;
			case 4:
				gameObject.setScale(.3);
			break;
			case 5:
				gameObject.setScale(.7);
			break;
			default:
				break;
		}
		}
		 this.addHintPanelElements();
	}

	addHintPanelElements() {
		this.table = this.scene.add.image(this.scene.cameras.main.width * .14, this.scene.cameras.main.height * .82, g_assetsKeyJSON.TABLE)
		.setScale(.32).setDepth(2000);

		this.shelfOne = this.scene.add.image(this.scene.cameras.main.width * .45, this.scene.cameras.main.height * .6,g_assetsKeyJSON.SHELFONE).setScale(.3).setDepth(2000);
		
		this.lipton = this.scene.add.image(this.scene.cameras.main.width * 1.42, this.scene.cameras.main.height * .6,g_assetsKeyJSON.LIPTON).setScale(1).setDepth(2000);
		this.shelftwo = this.scene.add.image(this.scene.cameras.main.width * .9, this.scene.cameras.main.height * .6,g_assetsKeyJSON.SHELFTWO).setScale(.3).setDepth(2000);
	}

	addHintTextAndIcon() {
		this.hintText = new IntroText(this.scene,this.scene.cameras.main.width * .45, this.scene.cameras.main.height * .805,HINT_TEXT[0],33,"#F3B231").setScrollFactor(0);
	}

	addDialogBox() {
		var _self = this;
		this.dialogBg = this.scene.add.image(this.scene.cameras.main.width * .45, this.scene.cameras.main.height * .8,g_assetsKeyJSON.INSTRUCTIONBOX).setScale(0,.5).setDepth(2000);
		var dialogBGtween = _self.scene.tweens.add({
			targets: this.dialogBg,
			scaleX: 0.6,
			duration: 1000,
			ease: "Bounce.Out",
			onComplete: function () {
				_self.addHintTextAndIcon();
			}
		});
	}

	fadeOutputScreen() {
		var _self = this;
		this.posmElementsArr.forEach(function (element) {
			var fadeInText = _self.scene.tweens.add({
				targets: element,
				alpha: 0,
				duration: 1500,
				yoyo: true,
				repeat: -1,
				ease: "Power",
				callback: function () {
					element.destroy();
				}
			});
		});
		var tweenOutput = this.scene.tweens.add({
			targets: [this.hintText,this.table,this.poster,this.dialogBg],
		 	duration: FADE_TWEEN_DURATION,
		 	scale: 0,
			alpha:0,
		 	ease: "Power",
			onComplete: function() {
				_self.scene.startGame();
				_self.outputImg.alpha = 0;
				//_self.loadPlayScreen();
			}
		 });
	}

	loadPlayScreen() {
		var _self = this;
		this.startBtn = this.scene.add.image(this.scene.cameras.main.width * .55,this.scene.cameras.main.height * .75,g_assetsKeyJSON.RIGHTARROW).setScale(0.35).setInteractive().on('pointerdown', () => {
			_self.scene.startGame();
			_self.startBtn.removeInteractive();
			_self.startBtn.destroy();
			_self.destroyUIElements();
		});
		this.logo = this.scene.add.image(this.scene.cameras.main.width * .55,this.scene.cameras.main.height * .35, g_assetsKeyJSON.GAMELOGO).setScale(.35)
	}

	destroyUIElements() {
		this.logo.destroy();
	}

	dialogText() {
		this.introDialog = new IntroText(this.scene,this.scene.cameras.main.width * .52, this.scene.cameras.main.height * .20,
										INTRO_DIALOG[0],30,"#F3B231");

		this.introDialog2 = new IntroText(this.scene,this.scene.cameras.main.width * .57, this.scene.cameras.main.height * .26,
										 INTRO_DIALOG[1],30,"#F3B231");

		this.dialog = new IntroText(this.scene,this.scene.cameras.main.width * .57, this.scene.cameras.main.height * .32,
										INTRO_DIALOG[2],30, "#F3B231").setAlpha(0);
	}

}

export default uiIntro;
