import IntroText from "../UIpanel/Introtext.js";

class TutorialOverlay extends Phaser.GameObjects.Container {

	constructor(scene, x, y) {
		super(scene, 0, 0);
		this.scene = scene;
		this.scene.add.existing(this);
        this.animations = [];
        this.createAnims();
        this.addRack();
	}

    addRack() {
        this.tutorialRack = this.scene.add.image(this.scene.cameras.main.width * 2.5,this.scene.cameras.main.height * .55,g_assetsKeyJSON.RACK).setScale(.4,.5).setOrigin(0.5);
        this.add(this.tutorialRack);
      
        var _self = this;
        var tweenRack = this.scene.tweens.add({
            targets: this.tutorialRack,
            x: this.scene.cameras.main.width * .5,
            duration: 500,
            ease: "Power",
            onComplete: function () {
                _self.animateShelfObjects();
            }
          });
    }

    createAnims() {
        var fivestar = this.scene.anims.create({
			key: 'fivestarAnim',
			frames: [
				{ key: g_assetsKeyJSON.FIVESTARWGLOW},
				{ key: g_assetsKeyJSON.FIVESTARWOGLOW}
			],
			frameRate: 1,
			repeat: -1
		});

		var mint = this.scene.anims.create({
			key: 'mintAnim',
			frames: [
				{ key: g_assetsKeyJSON.MINTWGLOW},
				{ key: g_assetsKeyJSON.MINTWOGLOW}
			],
			frameRate: 1,
			repeat: -1
		});

		var gems = this.scene.anims.create({
			key: 'gemsAnim',
			frames: [
				{ key: g_assetsKeyJSON.GEMSWGLOW},
				{ key: g_assetsKeyJSON.GEMSWOGLOW }
			],
			frameRate: 1,
			repeat: -1
		});


		var toffee = this.scene.anims.create({
			key: 'toffeeAnim',
			frames: [
				{ key: g_assetsKeyJSON.TOFFEEWGLOW},
				{ key: g_assetsKeyJSON.TOFFEEWOGLOW}
			],
			frameRate: 1,
			repeat: -1
		});


        var wobbler = this.scene.anims.create({
			key: 'wobblerAnim',
			frames: [
				{ key: g_assetsKeyJSON.WOBBLERGLOW},
				{ key: g_assetsKeyJSON.WOOBLER}
			],
			frameRate: 1,
			repeat: -1
		});


        var dairybox = this.scene.anims.create({
			key: 'dairyboxAnim',
			frames: [
				{ key: g_assetsKeyJSON.DAIRYBOXGLOW},
				{ key: g_assetsKeyJSON.DAIRYBOX}
			],
			frameRate: 1,
			repeat: -1
		});

        var displayUnit = this.scene.anims.create({
			key: 'displayAnim',
			frames: [
				{ key: g_assetsKeyJSON.DISPLAYGLOW},
				{ key: g_assetsKeyJSON.DISPLAYWOGLOW}
			],
			frameRate: 1,
			repeat: -1
		});
       
		this.animations.push("fivestarAnim","mintAnim","gemsAnim","toffeeAnim","wobblerAnim","dairyboxAnim","displayAnim")
		
    }

    animateShelfObjects() {

        this.questionX = [this.tutorialRack.width * .48, this.tutorialRack.width * .48,
            this.tutorialRack.width * .48,this.tutorialRack.width * .48,this.tutorialRack.width * .295,this.tutorialRack.width * .675,this.tutorialRack.width * .15];
        this.questionY = [this.tutorialRack.height * .25, this.tutorialRack.height * .4,
            this.tutorialRack.height * .53, this.tutorialRack.height * .66,this.tutorialRack.height * .35,this.tutorialRack.height * .38,this.tutorialRack.height * .6];
		
		this.itemsStrArr = ITEM_STR_ARR_LEVEL2;
		this.posmElementsArr =[];
        this.scene.cameras.main.zoom = 1.2;

		for(let i = 0;i< this.itemsStrArr.length;i++) {
			var gameObject = this.scene.add.sprite(this.questionX[i], this.questionY[i],this.itemsStrArr[i]).play(this.animations[i]).setDepth(2000);
			this.add(gameObject);
			switch(i+1) {
			case 1:
				gameObject.setScale(.4);
			break;
			case 2:
				gameObject.setScale(.4);
			break;
			case 3:
				gameObject.setScale(.4);
			break;
			case 4:
				gameObject.setScale(.4);
			break;
			case 5:
				gameObject.setScale(.25);
			break;
            case 6:
				gameObject.setScale(.15);
			break;
            case 7:
				gameObject.setScale(.4);
			break;
            case 8:
				gameObject.setScale(.7);
			break;
			default:
				break;
		}
		}
        this.addDialogBox();
    }

    
	addHintTextAndIcon() {
		this.hintText = new IntroText(this.scene,this.scene.cameras.main.width * .45, this.scene.cameras.main.height * .805,HINT_TEXT[0],33,"#F3B231").setScrollFactor(0).setDepth(5000);
        this.add(this.hintText);
	}

	addDialogBox() {
		var _self = this;
		this.dialogBg = this.scene.add.image(this.scene.cameras.main.width * .45, this.scene.cameras.main.height * .8,g_assetsKeyJSON.INSTRUCTIONBOX).setScale(0,.3).setDepth(5000);
        this.add(this.dialogBg);
        _self.closeBtn = _self.scene.add.image(_self.scene.cameras.main.width * .85,_self.scene.cameras.main.height * .8,g_assetsKeyJSON.RIGHTARROW).setScale(0.15).setDepth(2200).setScrollFactor(0).setInteractive().on('pointerdown', () => {
            _self.fadeOutputScreen();
            _self.closeBtn.disableInteractive();
            _self.closeBtn.destroy();
        });  
        this.add(this.closeBtn);
		var dialogBGtween = _self.scene.tweens.add({
			targets: this.dialogBg,
			scaleX: 0.55,
			duration: 1000,
			ease: "Bounce.Out",
			onComplete: function () {
				_self.addHintTextAndIcon();
			}
		});
	}

    fadeOutputScreen(){
        this.setAlpha(0);
        this.scene.cameras.main.fadeIn(3000);
        this.scene.cameras.main.zoom = 1;
        this.scene.startGame();
    }
   





    

}

export default TutorialOverlay;
