class uipanel extends Phaser.GameObjects.Container {

	constructor(scene,x,y) {
        super(scene,0,0);
        this.scene = scene;
        this.scene.add.existing(this);
        this.score = TOTAL_SCORE;
        this.addScore();
        this.addScoreText();
        this.cashBackTapped = false;

        if(CURRENT_LEVEL == 0) {
            this.addTimerCard();
            this.fixedTimer = 60;
            this.addTimer(this.fixedTimer);
            this.startGameTimer();
        }
	}

    addScore() {
        this.scoreCard = this.scene.add.image(this.scene.cameras.main.width * .1, this.scene.cameras.main.height * .20, g_assetsKeyJSON.SCORE).setScale(.65)
        this.yellowGlow = this.scene.add.image(this.scene.cameras.main.width * .1, this.scene.cameras.main.height * .20, g_assetsKeyJSON.GLOWBOX).setScale(.7).setAlpha(0)
    }

    addTimerCard() {
        this.timeCard = this.scene.add.image(this.scene.cameras.main.width * .9, this.scene.cameras.main.height * .20, g_assetsKeyJSON.TIME).setScale(.65)
    }

    addScoreText(){
        this.scoreText = this.scene.add
        .text(this.scene.cameras.main.width * .11, this.scene.cameras.main.height * .20, "0")
        .setFontFamily("sapisbi")
        .setColor("#F3B231")
        .setStroke('#F3B231', 1)
        .setFontSize(32)
        .setOrigin(0.5)
        .setDepth(1501)
        .setScrollFactor(0);
    }

    updateScore(score) {
        this.score += score;
        this.scoreText.setText(this.score+ "")
    }

    startGameTimer(){
        var self = this;
        this.gameStartTimer = setInterval(function () {
            if(g_currentGameState != "pause")
                self.runTimer();
          }, 1000);
    }
 
    addTimer(fixedTimer) {
        this.totalMinutes = Math.floor(fixedTimer / 60);
        this.totalRemaining = fixedTimer % 60;

        this.timeInMinutesText = this.scene.add
        .text(this.scene.cameras.main.width * .89, this.scene.cameras.main.height * .20, this.totalMinutes + "")
        .setFontFamily("sapisbi")
        .setColor("#F3B231")
        .setStroke('#F3B231', 1)
        .setFontSize(25)
        .setOrigin(0.5)
        .setDepth(1501)
        .setScrollFactor(0);

        this.colon = this.scene.add
        .text(this.scene.cameras.main.width * .91, this.scene.cameras.main.height * .20, ":")
        .setFontFamily("sapisbi")
        .setColor("#F3B231")
        .setStroke('#F3B231', 1)
        .setFontSize(25)
        .setOrigin(0.5)
        .setDepth(1501)
        .setScrollFactor(0);

        this.timeInSeconds = this.scene.add
        .text(this.scene.cameras.main.width * .93, this.scene.cameras.main.height * .20, this.totalRemaining + "")
        .setFontFamily("sapisbi")
        .setColor("#F3B231")
        .setStroke('#F3B231', 1)
        .setFontSize(25)
        .setOrigin(0.5)
        .setDepth(1501)
        .setScrollFactor(0)
    }

    runTimer(){
        console.log("runtimer",this.totalRemaining)
        if(this.totalRemaining > 0) {
            this.totalRemaining--;
            var currentStr = this.totalRemaining + "";
            this.totalRemaining < 10 ? this.timeInSeconds.setText("0" + currentStr) 
                                      : this.timeInSeconds.setText(currentStr);
        } else if(this.totalRemaining == 0 && this.totalMinutes !== 0) {
            this.totalMinutes = this.totalMinutes - 1;
            this.timeInMinutesText.setText(this.totalMinutes + "");
            this.totalRemaining = 59;
            this.timeInSeconds.setText(this.totalRemaining + "");
        } else {
            if(!this.scene.gameOver) {
                this.scene.gameOver = true;
                this.scene.loadResultPanel();
            }
        }
    }

    removeTimer(){
        clearInterval(this.gameStartTimer);
    }

    triggerTimeUp() {
        CURRENT_LEVEL++;
        this.timeup = this.scene.add.image(this.scene.cameras.main.width * .5, -this.scene.cameras.main.height * 2.5,g_assetsKeyJSON.POPUP).setScale(0.6).setScrollFactor(0);
      
        this.godrays = this.scene.add.image(this.scene.cameras.main.width * .5,this.scene.cameras.main.height * .55,g_assetsKeyJSON.GODRAYS).setScale(0).setAlpha(0);

        var _self = this;   
        var tweenPopup = this.scene.tweens.add({
            targets: this.timeup,
            duration:500,
            y:this.scene.cameras.main.height *.45,
            ease:"Sine.Out",
            onComplete: function () {
                if(CURRENT_LEVEL == TOTAL_LEVEL) {
                    _self.animateGodrays();
                } else {
                    _self.loadNextBtn();
                    _self.addFinalScoreText();
                    _self.addConfetti();
                }
            }
        });
    }

    loadNextBtn() {
        this.nextBtn = this.scene.add.image(this.scene.cameras.main.width * .5, this.scene.cameras.main.height * .8, g_assetsKeyJSON.NEXTBTN).setScale(.5).setInteractive().on('pointerdown', () => {
                this.scene.scene.start("LevelTwo");
        });
    }

    animateGodrays() {
        var _self = this;
        this.godrays.setScale(.7);
        var animateGodrays = this.scene.tweens.add({
            targets: this.godrays,
            duration:1500,
            angle : 360,
            ease:"linear",
            callback: function () {
                 _self.addFinalScoreText();
            }
        });
    }

    enableGameOverElements() {
      this.destroyCashbackTexts();
      this.finalScoreText.setAlpha(1);
      this.timeup.setAlpha(1);
    }

    addConfetti() {

        this.confetti = this.scene.add.sprite(this.scene.cameras.main.width* .5,this.scene.cameras.main.height*.5, "confetti").setScale(2).setScrollFactor(0);

		 this.scene.anims.create({
		 	key:"confettiAnim",
		 	frames: this.scene.anims.generateFrameNumbers('confetti', { start: 0, end: 64 }),
		 	frameRate: 45
		 });

         this.confetti.play("confettiAnim");
    }

    addFinalScoreText() {
        this.finalScoreText = this.scene.add
        .text(this.scene.cameras.main.width * .51, this.scene.cameras.main.height * .62, this.score+"")
        .setFontFamily("sapisbi")
        .setColor("#F3B231")
        .setFontSize(40)
        .setOrigin(0.5)
        .setStroke('#F3B231', 2)
        .setDepth(1501)
        .setScrollFactor(0);

        if(CURRENT_LEVEL == TOTAL_LEVEL) {
            console.log("FINAL_SCORE",GAME_TYPE);
            (GAME_TYPE == "fixed") ? FINAL_SCORE = GAME_SCORE : FINAL_SCORE = this.score;
            this.addHandcursorAnimation();
            g_gameServer.sendScoreToApp();
        }
    }

    addHandcursorAnimation() {
        this.handCursor = this.scene.add.image(this.scene.cameras.main.width * .95,this.scene.cameras.main.height * .18,g_assetsKeyJSON.HANDC).setScale(0.15).setDepth(1000);
		this.cursorAnimation = this.scene.TweenManager.setProperties(this.handCursor,CURSORANIM_SCALE_PROPS);
    }


    resetScoreCard() {
        this.scoreCard.destroy();
        this.scoreText.destroy();
        this.timerCard.destroy();
        this.timeInMinutesText.destroy();
        this.colon.destroy();
        this.timeInSeconds.destroy();
        this.timeup.destroy();
    }

    
    restoreGame() {
        CURRENT_LEVEL = 0;
        this.scene.scene.start("Game");
    }

}


export default uipanel;
