import LoadScene from "../scenes/LoadScene.js";
import GameScene from "../scenes/GameScene.js";
import LevelTwo from "../scenes/levelTwo.js";


export default {
	type: Phaser.AUTO,
	parent: "game",
	width: 1280,
	height: 720,
    transparent: true,
	antialias: true,
	scale: {
		 mode: Phaser.Scale.WIDTH_CONTROLS_HEIGHT,
		 autoCenter: Phaser.Scale.CENTER_BOTH,
		 width: 1280,
		 height: 720
	}, 
	loader: {
		crossOrigin: true
	},
	devicePixelRatio: window.devicePixelRatio,
	scene: [LoadScene, 
			GameScene,
			LevelTwo],
	physics: {
		default: "arcade",
		arcade: {
			gravity: { x: 0, y: 0 }
		},
		enableBody: true
	}
};

