class collectible extends Phaser.GameObjects.Container {

	constructor(scene,x,y,ground,objects,group) {
        super(scene,0,0)
        this.scene.add.existing(this);
        this.ground = ground;
        this.scene = scene;
        this.objects = objects;
        this.randomObject = ["danger","TV","fragile","fruits","trolly","coinRotate"];
        this.randomObjPos = [0.35,0.1,0.3,0.13,0.18];
        this.scoreImg = ["2PointN","2Point","2PointN","2Point","10Point","2Point"];
        this.trollyCont = this.scene.add.container(0, 0);
        this.collectiveGrp = group;
        this.generateRandomCollective(ground);
	}
 
    generateRandomCollective(ground){
        this.objectId = Phaser.Math.Between(0,5);
        //if(this.objectId == 4) 
        this.itemStr = this.randomObject[this.objectId]; 
        console.log("this.itemStr",this.itemStr);
        this.currentObjscale = this.randomObjPos[this.objectId];
        this.noOfItem = Phaser.Math.Between(1,4);
        this.itemStr == "trolly" ? this.noOfItem = 1 : this.noOfItem = this.noOfItem;
        this.intialX  = this.setIntialPosX(this.noOfItem,ground);
        this.addItem(ground);
    }

    generateGodRays(parentObject) {
        var godrays = this.scene.add.image(parentObject.x+6,parentObject.y,"godrays").setScale(0.1).setDepth(800);
        var tweenGodRay = this.scene.tweens.add({
			targets: godrays,
            duration: 1500,
            ease: "power",
            scale: 0.2, 
            rotation: 180,
            yoyo: true,
            repeat : -1
        });
        return godrays;
    }

    setIntialPosX(noOfItem,ground) {
        switch(noOfItem) {
            case 1:
                return  ground.x;
            case 2:
                return  ground.x + 20;
            case 3:
                return  ground.x + 80;
            case 4:
                return  ground.x + 110;
            default:
            break;
        }
    }

    addItem(ground) {
        for(let i=0;i<this.noOfItem;i++){
            if(this.objectId !== 5) {
            this.object = this.scene.physics.add.image(this.intialX,ground.y-50,[this.itemStr]).setDepth(1000).setScale(this.currentObjscale);
            this.object.tag = this.itemStr;
            this.object.scoreTag = this.scoreImg[i];
            this.collectiveGrp.add(this.object);
            if(this.objectId == 4){
                this.trollyCont.add(this.object);
                this.object.y = ground.y - 80;
            }
            this.objects.push(this.object);
            this.intialX -= 83;
        var trollyDest = this.trollyCont.x + 40; 
        var tweenTutorial = this.scene.tweens.add({
			targets: this.trollyCont,
            duration: 1500,
            ease: "power",
            x: trollyDest, 
            yoyo: true,
            repeat : -1
        });
    } else {
        this.object = this.scene.physics.add.sprite(this.intialX,ground.y-50,"coinRotate", 3).setOrigin(.5).setDepth(1000).setScale(1);
        this.object.tag = this.itemStr;
        this.collectiveGrp.add(this.object);
		this.scene.anims.create({
			key: 'coinRotated',
			frames: this.scene.anims.generateFrameNumbers('coinRotate', { start: 0, end: 3 }),
			frameRate: 6,
			repeat: -1
		});
        this.object.play('coinRotated');
        this.objects.push(this.object);
        this.intialX -= 83;
        }
    }
}
}

export default collectible;
