import uipanel from "../UIpanel/uiscene.js";
import uiIntro from "../UIpanel/introUI.js";
import Pickable from "../Pickable.js";
import TweenManager from "../utilities/Tween.js";
import IntroText from "../UIpanel/Introtext.js";
import Background from "../utilities/background.js";

// import audioManager from "../utilities/audiomanager.js";   //Yet to be used

class GameScene extends Phaser.Scene {
	constructor() {
		super("Game");
		console.log("GameLoaded");
	}

	preload() {
		let url = window.location.href;
        let params = (new URL(url)).searchParams;
		let tokenId = params.get('token');
		let taskId = params.get("taskid");
		let program_id = params.get('programid');
		BEARER_TOKEN = tokenId;
		TASK_ID = taskId;
		PROGRAM_ID = program_id;
	}

	create() {
		this.intialLoad = true;
		this.panningActivated = false;
		this.introUI = new uiIntro(this,0,0);
		this.TweenManager = new TweenManager(this);
		g_gameServer.getRewardDetails();
		}

	configParameters() {
		this.itemsStrArr = ITEM_STR_ARR;
		this.gameOver = false;
		this.rightWrongArr = [];
		this.currentDropValue = 0;
	}

	startGame() {
		this.configParameters();
		this.configureXandYArr();
		this.addGameElements();
		this.setxAndyPos();
		this.pushElements();
		this.playHandCursorAnimation();
		this.tutorialOverlay();
		this.firstObject.setProperties();
	}

	restartGame() {
		this.configParameters();
		this.configureXandYArr();
		this.addGameElements();
		this.cashier.setAlpha(1);
		this.fruitcart = this.add.image(this.cameras.main.width * .4, this.cameras.main.height * .85, g_assetsKeyJSON.FRUITCART).setScale(.2);   // .25
	//	this.addArrows();
		this.setxAndyPos();
		this.pushElements();
		this.uiElement = new uipanel(this, 0, 0);
	}

	update() {

	}
	
	tutorialOverlay() {
			var _self = this;
			_self.addDialogBox();
			this.arrowTween(this.nextBtn);
			this.nextBtn = this.add.image(this.cameras.main.width * .9, this.cameras.main.height * .81,g_assetsKeyJSON.RIGHTARROW).setScale(.18).setDepth(2004).setInteractive().on('pointerdown', () => {
				_self.uiElement = new uipanel(this, 0, 0);
				_self.hintText.destroy();
				_self.dialogBg.destroy();
				_self.addTableAndCashier();
				_self.objectAnimation.remove();
				_self.resetHandcursorAnimation();
				_self.nextBtn.destroy();
				_self.fadeInCamera();	
				//_self.addArrows();
			});
			this.arrowTween(this.nextBtn);
	}

	addDialogBox() {
		var _self = this;
		this.dialogBg = this.add.image(this.cameras.main.width * .45, this.cameras.main.height * .8,g_assetsKeyJSON.INSTRUCTIONBOX).setScale(0,.5).setDepth(2000);
		var dialogBGtween = _self.tweens.add({
			targets: this.dialogBg,
			scaleX: 0.6,
			duration: 1000,
			ease: "Bounce.Out",
			onComplete: function () {
				_self.addHintTextAndIcon();
			}
		});
	}

	addHintTextAndIcon() {
		this.hintText = new IntroText(this,this.cameras.main.width * .45, this.cameras.main.height * .8,IN_GAME_HINT[0],28,"#F3B231");
	}

	fadeInCamera() {
		var _self = this;
		this.cameras.main.fadeIn(3000);
	}

	scaleDownObjects(){

	}

	configureXandYArr(){
		//this.cameras.main.width * 1.18
		this.questionX = [this.cameras.main.width * .55, this.cameras.main.width * .71,
			this.cameras.main.width * .22, this.cameras.main.width * .2];
		//this.cameras.main.height * .62
		this.questionY = [this.cameras.main.height * .18, this.cameras.main.height * .6,
			this.cameras.main.height * .64, this.cameras.main.height * .32];
	}

	getxPos() {
		return this.questionX;
	}

	getyPos() {
		return this.questionY;
	}

	playHandCursorAnimation() {
		this.handCursor = this.add.image(this.cameras.main.width * .9,this.cameras.main.height * .7,g_assetsKeyJSON.HANDC).setScale(0.15).setOrigin(0.5,0).setDepth(1000);
		this.cursorAnimation = this.TweenManager.setProperties(this.handCursor,CURSORANIM_TWEEN_PROPS);
		this.firstObject.disableInteractive();
		this.objectAnimation = this.TweenManager.setProperties(this.firstObject,CURSORANIM_TWEEN_PROPS);
	}

	resetHandcursorAnimation(){
		this.firstObject.setInteractive();
		this.handCursor.alpha = 0;
		this.handCursor.destroy();
		this.firstObject.setPosition(this.cameras.main.width * .89,this.posmBoard.y + 10);
	}

	toggleFullScreen() {
		var isAndroid = /Android/i.test(navigator.userAgent);
		if(isAndroid){
		if(!document.fullscreenElement !== undefined){
		if (!document.fullscreenElement) {
			document.documentElement.requestFullscreen();
		} else {
			if (document.exitFullscreen) {
				document.exitFullscreen();
			}
		}
		} else {
			this.changeScaleMode();
		}
	}
	}

	setxAndyPos() {
		this.questionImgArr = [];
		for (let i = 0; i < this.questionX.length; i++) {
		this.questionImg = this.add.sprite(this.questionX[i], this.questionY[i], "arrowAnim").setScale(1);
		this.anims.create({
			key:"questionAnim",
			frames: this.anims.generateFrameNumbers('arrowAnim', { start: 0, end: 6 }),
			frameRate: 7,
			repeat: -1
		});
		this.questionImg.play("questionAnim");
		this.questionImg.key = i + 1;
		this.questionImgArr.push(this.questionImg);
		}
		this.insideContainer = false;
		this.falseDrop = false;
	}

	checkOverlap(objectA, objectB) {
		var boundsA = objectA.getBounds();
		var boundsB = objectB.getBounds();
		return Phaser.Geom.Intersects.GetRectangleIntersection(boundsA, boundsB);
	}

	pushElements() {
		this.itemsArr = [];
		this.startY;
		var currenrtY = this.posmBoard.y + 10;
		for (let i = 0; i < this.itemsStrArr.length; i++) {
			let object = new Pickable(this,this.cameras.main.width * .89,currenrtY,this.itemsStrArr[i]).setInteractive({ draggable: true });
			object.setDepth(150);
			currenrtY = object.displayHeight + currenrtY + 30;
		    let currentScale;
			switch(i) {
				case 0:
					currentScale = 0.5;
				break;
				case 1: 
					currentScale =  0.2;
				break;
				case 2:
					currentScale = 0.3;
				break;
				case 3:
					currentScale = 0.5;
				break;
				case 4:
					currentScale = 0.5;
				break;
				default:
					break;
			}
			object.setScale(currentScale);
			object.key = i + 1;
			object.index = i;
			if (i == 0) {
				this.startY = object.y;
				this.firstObject = object;
			}
			this.itemsArr.push(object);
		}
	}

	triggerTimeOver() {
		for(let i=0;i< this.itemsArr.length;i++) {
			this.itemsArr[i].alpha = 0;
		}
		for(let i=0;i<this.questionImgArr.length;i++) {
			this.questionImgArr[i].destroy();
		}

		this.movePanelAway();
	}

	movePanelAway() {
		var moveTable = this.tweens.add({
			targets: [this.cashier,this.table],
			x: -this.cameras.main.width * 0.5,
			duration: FADE_TWEEN_DURATION,
			ease: "Bounce.Out",
			callback: function () {
			}
		});

		var movePOSMboard = this.tweens.add({
			targets: this.posmBoard,
			x: this.cameras.main.width * 3,
			duration:FADE_TWEEN_DURATION,
			ease: "Bounce.Out",
			callback: function () {
			}
		});
	}
	
	checkIfGameOver() {
		if(this.currentDropValue == this.itemsStrArr.length) {
			this.loadResultPanel();
		} else if(this.currentDropValue == 1) {
			this.handCursor.alpha = 0;
			this.handCursor.destroy();
			this.cursorAnimation.remove();
		}
	}

	loadResultPanel() {
		var _self = this;
		//this.firstObject.fadeOutPosmBoard();
		this.animateResultIcons();
		setTimeout(_self.scoreScene, 5000,this); 
		this.uiElement.removeTimer();
		for(let i=0;i<this.itemsArr.length;i++) {
			this.itemsArr[i].disableInteractive();
		}
	}

	scoreScene(_self) {
		_self.gameOver = true;
		var cam = _self.cameras.main;
		var tempcameraPanning =  cam.pan(0, 0, 3000, 'Sine.easeInOut', false);
		_self.panningActivated = false;
		_self.uiElement.triggerTimeUp();
        _self.triggerTimeOver();
		_self.handCursor.destroy();
		for(let i=0;i<_self.rightWrongArr.length;i++) {
			_self.rightWrongArr[i].destroy();
		}
		_self.shelfOne.destroy();
		_self.shelftwo.destroy();
		_self.fruitcart.destroy();
		_self.dangleOne.destroy();
		_self.dangle.destroy();
		_self.dangleTwo.destroy();
		_self.lipton.destroy();

	}

	triggerSucessfulldrop(gameObject, currectQuestion, currentIndex,tempX) {
		gameObject.disableInteractive();
		gameObject.x = this.questionX[currentIndex];
		gameObject.y =  this.questionY[currentIndex];
		console.log(currectQuestion.key);
		if (gameObject.key == currectQuestion.key) {
			gameObject.removeInteractive();
			gameObject.x =  this.questionX[currentIndex];
			this.placeObjects(currectQuestion.key,gameObject);
			this.animateStarScale(gameObject);
			//this.placeRightIcon(gameObject);
			this.bounceElement(gameObject.index, this.startY);
			this.questionX.splice(currentIndex, 1);
			this.questionY.splice(currentIndex, 1);
			this.questionImgArr.splice(currentIndex, 1);
			currectQuestion.destroy();
			gameObject.setDepth(80);
			gameObject.setScrollFactor(1);
		} else {
			// (currectQuestion.key == 3 || (currectQuestion.key == 2 && this.panningActivated == true)) ? gameObject.x = tempX :  gameObject.x = this.questionX[currentIndex];
			currectQuestion.setAlpha(0);
			this.placeWrongIcon(gameObject,currectQuestion);
			this.animateWrongIcon(gameObject,currectQuestion);
		}
	}

	placeObject(index,object) {
	}

	placeObjects(index,object) {
		console.warn(index)
		switch(index) {
			case 1:
				this.multiplyDangels(object);
			break;
			case 2:
				object.setScale(.21);
			break;
			case 3:
				//object.setScale(.35);
			break;
			case 4:
				object.setScale(.5);
			break;
			case 5:
				//object.setScale(.3);
			break;
			default:
				break;
		}
	}

	multiplyDangels(gameObject) {
		this.dangle = this.add.image(this.cameras.main.width * .25,this.cameras.main.height * .15,g_assetsKeyJSON.NACHOS).setDepth(1500).setScale(.15);
		this.dangleOne =  this.add.image(this.cameras.main.width * .75,this.cameras.main.height * .15,g_assetsKeyJSON.NACHOS).setDepth(1500).setScale(.2);
		this.dangleTwo = this.add.image(this.cameras.main.width * 1.1,this.cameras.main.height * .15,g_assetsKeyJSON.NACHOS).setDepth(1500).setScale(.3);
	}

	animateWrongIcon(gameObject,currectQuestion) {
		var _self = this;
		var wrongIcon = this.tweens.add({
			targets:this.objectWrong,
			scale:0.5,
			alpha:1,
			duration:250,
			ease: "Bounce.In",
			delay:750,
			onComplete: function () {
				gameObject.x = _self.cameras.main.width * .89;
				gameObject.y = _self.posmBoard.y + 10;;
				_self.objectWrong.destroy();
				gameObject.setInteractive();
				currectQuestion.setAlpha(1);
			}
		});
	}

	returnObjectToTable() {
		
	}

	bounceElement(index, startYPos) {
		var objBounce = this.tweens.add({
			targets: this.itemsArr[index + 1],
			y: startYPos,
			alpha:1,
			duration: FADE_TWEEN_DURATION,
			ease: "Power"
		});
	}

	placeRightIcon(gameObject) {
		var objectRight = this.add.image(gameObject.x,gameObject.y,g_assetsKeyJSON.RIGHT).setDepth(1500).setAlpha(1).setScale(0);
		this.animateResult(objectRight);
		this.rightWrongArr.push(objectRight);
	}

	placeWrongIcon(gameObject,currentIcon) {
		this.objectWrong = this.add.image(currentIcon.x,currentIcon.y,g_assetsKeyJSON.WRONG).setDepth(1500).setScale(3).setAlpha(0);
		this.rightWrongArr.push(this.objectWrong);
	}
	
    animateStarScale(object) {
		this.currentDropValue++;
		this.checkIfGameOver();
		this.uiElement.updateScore(RIGHT_ANSWER);
		this.starpath = this.add.image(object.x,object.y,g_assetsKeyJSON.STARPATH).setDepth(1500).setScale(0).setAlpha(0);
		var _self = this;
		var starScaleAnim = this.tweens.add({
			targets: this.starpath,
			scale: 1,
			alpha:1,
			duration: 500,
			ease: "Power",
			onComplete: function () {
				_self.animateStarPath();
				_self.placeRightIcon(object);
			}
		});
	}

	animateStarPath() {
		var _self = this;
		var starPathAnim = this.tweens.add({
			targets: this.starpath,
			x: this.uiElement.scoreCard.x,
			y: this.uiElement.scoreCard.y,
			scale:0.2,
			alpha:0.2,
			duration: 500,
			ease: "Power",
			onComplete: function () {
				_self.starpath.alpha = 0;
				_self.starpath.scale = 0;
				_self.animateYellowGlow();
			}
		});
	}

    animateYellowGlow() {
		var _self = this;
		var starPathAnim = this.tweens.add({
			targets: this.uiElement.yellowGlow,
			yoyo:true,
			alpha:1,
			duration: 500,
			ease: "Power",
			onComplete: function () {
			}
		});
	}

	animateResultIcons() {
		var _self = this;
		this.rightWrongArr.forEach(function (element) {
			var fadeInText = _self.tweens.add({
				targets: element,
				scale: 0.3,
				alpha: 1,
				duration: BLINK_DURATION,
				ease: "Bounce.In",
				onComplete: function () { 
				}
			});
		});
	}

	animateResult(element) {
		var fadeInText = this.tweens.add({
			targets: element,
			scale: 0.3,
			alpha: 1,
			duration: BLINK_DURATION,
			ease: "Bounce.In",
			onComplete: function () { 
			}
		});
	}

	placeShelfElement(gameObject) {
		var layerObjectX = [gameObject.x - 57, gameObject.x + 55];
		var layerObjectY = [gameObject.y, gameObject.y - 60];
		var firstKey = ITEM_KEY;
		for (let i = 0; i < 2; i++) {
			this.questionImg = this.add.sprite(layerObjectX[i], layerObjectY[i], "arrowAnim").setScale(0.4).setDepth(1000).setAlpha(0);
			this.anims.create({
				key:"questionAnim",
				frames: this.anims.generateFrameNumbers('arrowAnim', { start: 0, end: 6 }),
				frameRate: 7,
				repeat: -1
			});
		this.questionImg.play("questionAnim");
		this.questionImg.key = i + firstKey;
		this.questionImgArr.push(this.questionImg);
		this.questionX.push(layerObjectX[i]);
		this.questionY.push(layerObjectY[i]);
		}
	}

	addGameElements() {

		console.log("this",this);
		this.Background = new Background(this,this.cameras.main.width * .5, this.cameras.main.height * .5,g_assetsKeyJSON.BACKGROUND);

		let shelfRatio = window.devicePixelRatio /6;
		//this.cashier.setAlpha(0);
		this.cashier.setPosition(this.cameras.main.width * .1, this.cameras.main.height * .7).setScale(0.5)
		 //setScale(.5)
		 this.posmBoard = this.add.image(this.cameras.main.width * .88, this.cameras.main.height * .64, g_assetsKeyJSON.POSMBOARD).setScale(0.7).setAlpha(0.7).setScrollFactor(0).setDepth(100);  // 0.7

		 this.shelfOne = this.add.image(this.cameras.main.width * .45, this.cameras.main.height * .6,g_assetsKeyJSON.SHELFONE).setScale(0.3);  //.3
		 this.table = this.add.image(this.cameras.main.width * .14, this.cameras.main.height * .83, g_assetsKeyJSON.TABLE)
		.setDepth(100)
		.setScale(.32);	
		
		 this.lipton = this.add.image(this.cameras.main.width * 1.42, this.cameras.main.height * .6,g_assetsKeyJSON.LIPTON).setScale(1);
	    //this.chiller = this.add.image(this.cameras.main.width * 1.05, this.cameras.main.height * .89,g_assetsKeyJSON.CHILLER).setScale(.6);
		 this.shelftwo = this.add.image(this.cameras.main.width * .9, this.cameras.main.height * .6,g_assetsKeyJSON.SHELFTWO).setScale(.3);   //.3
		 
		//posm
		// this.milo = this.add.image(this.cameras.main.width * .71, this.cameras.main.height * .55,g_assetsKeyJSON.MILO).setScale(.3);		 
		// this.dairyMilkShelf = this.add.image(this.cameras.main.width * 1.18, this.cameras.main.height * .6,g_assetsKeyJSON.DAIRYMILK_S).setScale(.5);

	}

	addTableAndCashier() {
		
		this.cashier.setPosition(this.cameras.main.width * .1, this.cameras.main.height * .7).setScale(0.5);
		this.cashier.setAlpha(1);
		this.fruitcart = this.add.image(this.cameras.main.width * .4, this.cameras.main.height * .85, g_assetsKeyJSON.FRUITCART).setScale(.15);   // .25

	}

	changeScaleMode() {
		//this.scale.scaleMode = 1;
	}


	arrowTween(arrowObj) {
		var tweenArrow = this.tweens.add({
			targets: arrowObj,
			scale: .3,
			yoyo: true,
			duration: TINT_DURATION,
			loop: -1,
			ease: "Sine.easeInOut",
			callback: function () {
			}
		});
	}

	scorllingDone(cam,panEffect) {
		this.posmBoard.setPosition(this.cameras.main.width * 1.5, this.cameras.main.height * .64);
	}

	addCashierAnimation() {
		this.cashier = this.add.sprite(this.cameras.main.width * .25, this.cameras.main.height * .7, 'cashier').setScale(.7).setDepth(99);

		this.anims.create({
			key: 'idle',
			frames: [
				{ key: 'cashier', frame: 'cashier1.png' },
				{ key: 'cashier', frame: 'cashier2.png' },
				{ key: 'cashier', frame: 'cashier3.png' },
				{ key: 'cashier', frame: 'cashier4.png' }
			],
			frameRate: 1,
			repeat: -1
		});
		this.cashier.play("idle");
	}

	resetGameScene() {
		for(let i=0;i<this.questionImgArr.length;i++) {
			this.questionImgArr[i].destroy();
		}
		var tempcameraPanning =  this.cameras.main.pan(0, 0, 3000, 'Sine.easeInOut', false);
		this.intialLoad = true;
		this.gameOver = false;
		this.insideContainer = false;
		this.falseDrop = false;
		this.questionX = [];
		this.questionY = [];
		this.itemsArr = [];
		this.itemsStrArr = [];
		this.restartGame();
		this.panningActivated = false;
	}

}

export default GameScene;
