import config from "../config/config.js";
// import LevelTwo from "./levelTwo.js";


class LoadScene extends Phaser.Scene {

	constructor() {
		super({
			key: 'loader',
			pack: {
				files: [
					{
						type: 'image',
						key: "bg",
						url: "assets/img/Introscene.png"
					},
					{
						type: 'image',
						key: "mindy",
						url: "assets/img/mindy.png"
					},
					{
						type: 'image',
						key: 'logo',
						url: "assets/img/logonew.png"
					}
				]
			}
		});
	}
/**************************************************************************************************************
 * Load splash screen elements
 */
	preload() {
		this.loadImages();
		this.loadAnimations();
		this.logo = this.add.image(this.cameras.main.width * .5, this.cameras.main.height * .5, "bg");
		this.title = this.add.image(this.cameras.main.width * .51, this.cameras.main.height * .3, "logo").setScale(.2)
		this.mindy = this.add.image(this.cameras.main.width * .4, this.cameras.main.height * .45, "mindy").setScale(.7).setDepth(2000);
		this.loadProgressBar();
	}


/**************************************************************************************************************
 * Process loading bar
 */
	loadProgressBar() {
		let progressBar = this.add.graphics();
		let progressBox = this.add.graphics();
		progressBox.fillStyle(0x222222, 0.1);
		progressBox.fillRect(
			config.width / 2 - 150,
			config.height / 2 - 30,
			320,
			50
		)

		//PERCENT TEXT
		let percentText = this.make.text({
			x: config.width / 2,
			y: config.height / 2 - 5,
			text: "0%",
			style: {
				font: "20px monospace",
				fill: "#222222"
			},
		})
		percentText.setOrigin(0.5, 0.5);

		this.load.on("progress", function (value) {
			progressBar.clear();
			progressBar.fillStyle(0xf8a942, 1);
			progressBar.fillRect(
				config.width / 2 - 140,
				config.height / 2 - 20,
				300 * value,
				30
			)
			percentText.setText(parseInt(value * 100) + " %");
		});

		this.load.on("fileprogress", function (file) { });
		this.loadComplete = false;
		var _self = this;
		this.load.on("complete", function () {
			progressBar.destroy();
			progressBox.destroy();
			percentText.destroy();
			this.loadComplete = true;
			_self.logo.destroy();
			_self.title.destroy();
			_self.mindy.destroy();
		});
	}

/**************************************************************************************************************
 * Iterate the resource json and preload the images
 */
	loadImages() {
		let resourcePath = Object.values(resourcesIngame);
		var dataLength = Object.keys(resourcePath).length;
		let resourceKey = Object.keys(resourcesIngame);
		for (let i = 0; i < dataLength; i++) {
			this.load.image(resourceKey[i], resourcePath[i]);
			var key = resourceKey[i];
			var value = resourceKey[i];
			g_assetsKeyJSON[key] = value;
		}
	}

/**************************************************************************************************************
 * preload the animation
 */
	loadAnimations() {
		this.load.atlas("cashier", "assets/img/cashierNew.png", "assets/img/cashierNew.json");
		this.load.spritesheet("confetti", "assets/img/confetti.png", { frameWidth: 512, frameHeight: 512, endFrame: 64 });
		this.load.spritesheet("arrowAnim", "assets/img/arrowanim.png", { frameWidth: 57, frameHeight: 62, endFrame: 6 });
	}

	loadFonts() {
		// this.load.bitmapFont('sapisbi',"fonts/Sapisbi.bmp");
	}


	create() {
		console.log("scene");
		this.scene.start("Game");
	}


}

export default LoadScene;

