import Background from "../utilities/background.js";
import TweenManager from "../utilities/Tween.js";
import Pickable from "../Pickable.js";
import uipanel from "../UIpanel/uiscene.js";
import TutorialOverlay  from "../UIpanel/tutorialOverlay.js";
import IntroText from "../UIpanel/Introtext.js";



class LevelTwo extends Phaser.Scene {
    constructor() {
		super("LevelTwo");
	  }

    create() {
      this.currentDropValue = 0;
      this.Background = new Background(this,this.cameras.main.width * .5,this.cameras.main.height * .5,g_assetsKeyJSON.BACKGROUND);
      this.TweenManager = new TweenManager(this);
      this.tutorialOverlay = new TutorialOverlay(this,0,0);
      
    }

    startGame(){
      this.rightWrongArr = [];
      this.randomizeArr = [];
      this.posmObjects = [];
      this.arrowIcondArr = [];
      this.wrongFaceArr = [];
      this.row = 0;
      this.indexOne = 0;
      this.indexTwo = 0;
      this.indexThree = 0;
      this.indexFour = 0;
      this.addGameElements();
      this.configureXandYArr();
      this.setxAndyPos();
      this.itemsStrArr = ITEM_STR_ARR_LEVEL2;
      this.cursorBool = false;
      this.uiElement = new uipanel(this, 0, 0);
      this.pushElements();
      this.tutorialOverlay.destroy();
    }

    addGameElements() {
      this.posmBoard = this.add.image(this.cameras.main.width * .88, this.cameras.main.height * .6, g_assetsKeyJSON.POSMBOARD).setScale(0.6).setAlpha(0.7).setScrollFactor(0).setDepth(100);  // 0.7
      this.rack = this.add.image(this.cameras.main.width * .46,this.cameras.main.height * .6,g_assetsKeyJSON.RACK).setScale(.5).setOrigin(0.5);
    }

    checkIfGameOver() {
      console.log("checkIfgameover",this.currentDropValue,this.itemsStrArr.length)
      if(this.currentDropValue == this.itemsStrArr.length ) {
        this.loadResultPanel();
      } else if(this.currentDropValue == 1) {
      }
    }

    animateStarPath() {
      var _self = this;
      var starPathAnim = this.tweens.add({
        targets: this.starpath,
        x: this.uiElement.scoreCard.x,
        y: this.uiElement.scoreCard.y,
        scale:0.2,
        alpha:0.2,
        duration: 500,
        ease: "Power",
        onComplete: function () {
          _self.starpath.alpha = 0;
          _self.starpath.scale = 0;
          _self.animateYellowGlow();
        }
      });
    }

    loadResultPanel() {
      var _self = this;
      //this.firstObject.fadeOutPosmBoard();
      this.animateResultIcons();
      this.yourText = this.add
      .text(this.cameras.main.width * 0.5, this.cameras.main.height * 0.2, "PERFECT EXECUTION!")
      .setFontFamily("font1")
      .setColor("#90181D")
      .setFontSize(40)
      .setOrigin(0.5)
      .setStroke('#90181D', 2)
      .setDepth(3000)
      .setScrollFactor(0);
      this.uiElement.addConfetti();
      setTimeout(_self.scoreScene, 5000,this); 
      this.uiElement.removeTimer();
      for(let i=0;i<this.itemsArr.length;i++) {
        this.itemsArr[i].disableInteractive();
      }
    }

    scoreScene(_self) {
      _self.gameOver = true;
      _self.uiElement.triggerTimeUp();
      _self.yourText.destroy();
       _self.triggerTimeOver();
       _self.rack.destroy();
       document.getElementById("closeBtnDiv").style.display ="block";
       
      for(let i=0;i<_self.posmObjects.length;i++) {
        _self.posmObjects[i].destroy();
      }
      for(let i=0;i<_self.rightWrongArr.length;i++) {
        _self.rightWrongArr[i].destroy();
      }
      for(let i=0;i<_self.arrowIcondArr.length;i++){
        _self.arrowIcondArr[i].destroy();
      }
    }

      movePanelAway() {
        var movePOSMboard = this.tweens.add({
          targets: this.posmBoard,
          x: this.cameras.main.width * 3,
          duration:FADE_TWEEN_DURATION,
          ease: "Bounce.Out",
          callback: function () {
          }
        });
      }

    triggerTimeOver() {
      for(let i=0;i< this.itemsArr.length;i++) {
        this.itemsArr[i].alpha = 0;
      }
      for(let i=0;i<this.questionImgArr.length;i++) {
        this.questionImgArr[i].destroy();
      }
  
      this.movePanelAway();
    }

    animateResultIcons() {
      var _self = this;
      this.rightWrongArr.forEach(function (element) {
        var fadeInText = _self.tweens.add({
          targets: element,
          scale: 0.2,
          alpha: 1,
          duration: BLINK_DURATION,
          ease: "Bounce.In",
          onComplete: function () { 
          }
        });
      });
    }


      pushElements() {
        this.itemsArr = [];
        this.startY;
        var currenrtY = this.posmBoard.y + 10;
        for (let i = 0; i < this.itemsStrArr.length; i++) {
          this.object = new Pickable(this,this.cameras.main.width * .89,currenrtY,this.itemsStrArr[i]).setInteractive({ draggable: true });
          this.object.setDepth(150);
          currenrtY = this.object.displayHeight + currenrtY + 80;
            let currentScale;
          switch(i) {
            case 0:
              currentScale = 0.5;
            break;
            case 1: 
              currentScale =  0.5;
            break;
            case 2:
              currentScale = 0.5;
            break;
            case 3:
              currentScale = 0.5;
            break;
            case 4:
              currentScale = 0.25;
            break;
            case 5:
              currentScale = 0.15;
            break;
            case 6:
              currentScale = 0.25;
            default:
              break;
          }
          this.object.setScale(currentScale);
          this.assignKeys(this.object,this.itemsStrArr[i]);
          // this.object.key = i + 1;
          this.object.index = i;
          if (i == 0) {
            this.startY = this.object.y;
            this.firstObject = this.object;
          }
          this.itemsArr.push(this.object);
        }
        this.firstObject.handleInputEvents();
    }

    assignKeys(object,keyString) {
      switch(keyString){
        case "FIVESTAR":
            object.key = 1;
        break;
        case "MINI":
            object.key = 2;
        break;
        case "GEMS":
            object.key = 3;
        break;
        case "TOFFEE":
            object.key = 4;
        break;
        case "WOOBLER":
            object.key = 5;
        break;
        case "DAIRYBOX":
            object.key = 6;
        break;
        case "DISPLAYUNIT":
            object.key = 7;
        break;
      }
    }

    scaleDownObjects(){

    }


    setxAndyPos() {
      this.questionImgArr = [];
      for (let i = 0; i < this.questionX.length; i++) {
      this.questionImg = this.add.sprite(this.questionX[i], this.questionY[i], "arrowAnim").setScale(1);
      this.anims.create({
        key:"questionAnim",
        frames: this.anims.generateFrameNumbers('arrowAnim', { start: 0, end: 6 }),
        frameRate: 7,
        repeat: -1
      });
      this.questionImg.play("questionAnim");
      this.arrowIcondArr.push(this.questionImg);
      if(i == 0 || i == 1 || i == 2 || i == 3) {
        this.rectBox = this.add.image(this.questionX[i], this.questionY[i], g_assetsKeyJSON.GRAYBOX).setScale(0.7,0.15).setAlpha(0);
        this.rectBox.key = i + 1;
        this.questionImgArr.push(this.rectBox);
      } else {
        this.questionImg.key = i + 1;
        this.questionImgArr.push(this.questionImg);
      }
      }
      this.insideContainer = false;
      this.falseDrop = false;
    }
    
    configureXandYArr(){
      this.questionX = [this.rack.width * .45, this.rack.width * .45,
        this.rack.width * .45,this.rack.width * .45,this.rack.width * .21,this.rack.width * .69,this.rack.width * .1];
      this.questionY = [this.rack.height * .3, this.rack.height * .45,
        this.rack.height * .58, this.rack.height * .7,this.rack.height * .4,this.rack.height * .4,this.rack.height * .6];
    }

    checkOverlap(objectA, objectB) {
      var boundsA = objectA.getBounds();
      var boundsB = objectB.getBounds();
      return Phaser.Geom.Intersects.GetRectangleIntersection(boundsA, boundsB);
    }


    triggerSucessfulldrop(gameObject, currectQuestion, currentIndex,tempX) {
      gameObject.disableInteractive();
      console.log(currectQuestion.key);
      this.placeObject(currentIndex,gameObject);
      if (gameObject.key == currectQuestion.key) {
        gameObject.removeInteractive();
        console.log("gameObject.keytrigger",gameObject.key);
        if(gameObject.key == 1 ||gameObject.key == 2 ||gameObject.key == 3 ||gameObject.key == 4) {
          this.multiplyObjects(gameObject,currentIndex);
          this.arrowIcondArr[gameObject.key-1].setAlpha(0);
        } else  {
          gameObject.x = this.questionX[currentIndex];
          gameObject.y =  this.questionY[currentIndex];
          this.animateStarScale(gameObject);
        }
        
        this.questionX.splice(currentIndex, 1);
        this.questionY.splice(currentIndex, 1);
        if(gameObject.key == 6 || gameObject.key == 5 || gameObject.key == 7) 
          this.bounceElement(gameObject.index,this.startY)
        this.questionImgArr.splice(currentIndex, 1);
        currectQuestion.destroy();
        gameObject.setDepth(80);
        gameObject.setScrollFactor(1);
      } else {
        if(gameObject.key == 1 || gameObject.key == 2 || gameObject.key == 3 || gameObject.key == 4)
          currectQuestion.setAlpha(0);
        this.placeWrongIcon(gameObject,currectQuestion);
        this.animateWrongIcon(gameObject,currectQuestion);
        //this.bounceElement(gameObject.index, this.startY);
      }
    }


    placeObject(index,object) {
      switch(index) {
        case 1:
          object.setScale(.25);
        break;
        case 2:
          object.setScale(.25);
        break;
        case 3:
          object.setScale(.25);
        break;
        case 4:
          object.setScale(.25);
        break;
        case 5:
          object.setScale(.25);
        break;
        case 6:
          object.setScale(.2);
        break;
        case 7:
          object.setScale(.15);
        break;
        default:
          break;
      }
    }


    randomizeNumber() {
       var randomizeArr = [];
       var randomArr = [1,2,3,4,5,6,7,8,9]
       var count =  Math.floor(Math.random() * 4) + 2;
       console.log("Count",count)
       for(let i=0;i<count;i++) {
       var random =  Math.floor(Math.random() * randomArr.length);
       randomizeArr.push(randomArr[random]);
       randomArr.splice(random,1);
       }
       return randomizeArr;
    }


    multiplyObjects(gameObject,currentIndex) {
      this.multipliedObjectArr = [];
      this.row ++;
      gameObject.x = this.rack.width * .25;
      gameObject.y = this.questionY[currentIndex];
      this.posmObjects.push(gameObject);
      this.multipliedObjectArr.push(gameObject);
      for(let i=0;i<9;i++) {
        var multipliedObject = this.add.image(gameObject.x,gameObject.y,gameObject.texture).setScale(.25).setAlpha(0);
        multipliedObject.key = gameObject.key;
        multipliedObject.index = gameObject.index;
        this.multipliedObjectArr.push(multipliedObject);
        this.posmObjects.push(multipliedObject);
      }
      this.misPlaceObjects();
      var index=1;
      this.tweenshelfObjects(index);
    }

    slideOutPosmBoard() {
      var dialogBGtween = this.tweens.add({
        targets: this.posmBoard,
        x: 0.55,
        duration: 1000,
        ease: "Bounce.Out",
        onComplete: function () {
         // _self.addHintTextAndIcon();
        }
      });
    }

    misPlaceObjects() {
      var currentRandArr = [];
      currentRandArr = this.randomizeNumber();
      for(let i=0;i<this.multipliedObjectArr.length;i++) {
        for(let j=0;j<currentRandArr.length;j++) {
          if(i == currentRandArr[j]) {
            if(this.cursorBool == false) {
              this.cursorBool = true;
              this.multipliedObjectArr[i].tag = "MISPLACED";
            }
            let randomFacing = Math.floor(Math.random() * 3);
            this.doWrongFacing(randomFacing,this.multipliedObjectArr[i]);
            this.rowIndex = {row: this.row, length: currentRandArr.length,value:this.multipliedObjectArr[i]};
            this.wrongFaceArr.push(this.rowIndex);
        }
      }
    }
    }

    setInteractProperty() {
      for(let i=0;i<this.wrongFaceArr.length;i++) {
        if(this.wrongFaceArr[i].value.input == null) {
         this.wrongFaceArr[i].value.setInteractive().on('pointerdown', () => {
           //this.wrongFaceArr[i].disableInteractive();
           if(this.wrongFaceArr[i].value.tag == "MISPLACED") 
              this.removeInstructions();
              this.resetObject(this.wrongFaceArr[i].value);
              this.incrementCurrentIndex(this.wrongFaceArr[i].row,this.wrongFaceArr[i].length,this.wrongFaceArr[i].value);
          });
        }
           }
      }

      incrementCurrentIndex(row,length,gameObject) {
        console.log(row,length)
        switch(row) {
          case 1:
            this.indexOne++;
            if(this.indexOne == length)
              this.animateStarScale(gameObject);
          break;
          case 2:
            this.indexTwo++;
            console.log("indexTwo",this.indexTwo,length)
            if(this.indexTwo == length)
              this.animateStarScale(gameObject);
          break;
          case 3:
            this.indexThree++;
            console.log("indexThree",this.indexThree,length)
            if(this.indexThree == length)
              this.animateStarScale(gameObject);
          break;
          case 4:
            this.indexFour++;
            console.log("indexFour",this.indexFour,length)
            if(this.indexFour == length)
              this.animateStarScale(gameObject);
          break;
          default:
            break;
        }
        
      }


    removeInstructions() {
      this.handCursor.destroy();
      this.dialogBg.destroy();
      this.hintText.destroy();
    }

    addCursor(object){
        this.handCursor = this.add.image(object.x,object.y,g_assetsKeyJSON.HANDC).setScale(0.05).setOrigin(0.5,0).setDepth(1000);
        this.tweens.add({
          targets:this.handCursor,
          yoyo: true,
          scale: 0.1,
          loop: -1,
          ease: "Power",
          duration: 1500
        });
        this.addInstruction();
      }

    addInstruction() {
      var _self = this;
      this.dialogBg = this.add.image(this.cameras.main.width * .45, this.cameras.main.height * .82,g_assetsKeyJSON.INSTRUCTIONBOX).setScale(0,.3).setDepth(5000);
      var dialogBGtween = this.tweens.add({
        targets: this.dialogBg,
        scaleX: 0.55,
        duration: 1000,
        ease: "Bounce.Out",
        onComplete: function () {
          _self.addHintTextAndIcon();
        }
      });
    }

    addHintTextAndIcon() {
          this.hintText = new IntroText(this,this.cameras.main.width * .45, this.cameras.main.height * .821,TAP_HINT[0],33,"#F3B231").setScrollFactor(0).setDepth(5000);
    }

    doWrongFacing(key,object) {
      switch(key) {
        case 0: 
          object.angle = 90;
        break;
        case 1: 
          object.angle = 180;
        break;
        case 2:
          object.angle = -90;
        break;
        default:
        break;
      }
    }

    resetObject(gameObject) {
      this.tweens.add({
        targets:gameObject,
        angle: 0,
        ease: "Bounce.Out",
        duration: 500
      })

    } 
    
    tweenshelfObjects(i) {
      var _self = this;
      this.tweens.add({    
        targets: this.multipliedObjectArr[i],
        x:this.multipliedObjectArr[i-1].x+this.multipliedObjectArr[i-1].displayWidth,
        duration: 500,
        alpha: 1,
        ease: "Power",
        onComplete: function () {
            i++;
            if(i<= 9) 
              _self.tweenshelfObjects(i);
            else{
              _self.onCompleteTween();
              return;
            }
        }
      })
    }

    onCompleteTween(){
      for(let i=0;i<this.multipliedObjectArr.length;i++){
        console.log("oncompleteTween",this.multipliedObjectArr[i].tag);
        if(this.multipliedObjectArr[i].tag == "MISPLACED") {
            console.log("multiplier",this.multipliedObjectArr[i])
            this.addCursor(this.multipliedObjectArr[i]);
            break;
        }
      }
      this.setInteractProperty();
      this.bounceElement(this.multipliedObjectArr[0].index, this.startY);
    }

    placeWrongIcon(gameObject,currentIcon) {
        this.objectWrong = this.add.image(currentIcon.x,currentIcon.y,g_assetsKeyJSON.WRONG).setDepth(1500).setScale(3).setAlpha(0);
        this.rightWrongArr.push(this.objectWrong);
    }

    animateWrongIcon(gameObject,currectQuestion) {
      var _self = this;
      var wrongIcon = this.tweens.add({
        targets:this.objectWrong,
        scale:0.5,
        alpha:1,
        duration:250,
        ease: "Bounce.In",
        delay:750,
        onComplete: function () {
         gameObject.x = _self.cameras.main.width * .89;
         gameObject.y = _self.posmBoard.y + 10;;
         _self.objectWrong.destroy();
         gameObject.setInteractive();
        // currectQuestion.setAlpha(1);
        }
      });
    }

    animateStarScale(object) {
      this.currentDropValue++;
      this.checkIfGameOver();
      this.uiElement.updateScore(RIGHT_ANSWER);
      this.starpath = this.add.image(object.x,object.y,g_assetsKeyJSON.STARPATH).setDepth(1500).setScale(0).setAlpha(0);
      var _self = this;
      var starScaleAnim = this.tweens.add({
        targets: this.starpath,
        scale: 1,
        alpha:1,
        duration: 500,
        ease: "Power",
        onComplete: function () {
          _self.animateStarPath();
          _self.placeRightIcon(object);
        }
      });
    }

    bounceElement(index, startYPos) {
      var objBounce = this.tweens.add({
        targets: this.itemsArr[index + 1],
        y: startYPos,
        alpha:1,
        duration: FADE_TWEEN_DURATION,
        ease: "Power"
      });
    }

    placeRightIcon(gameObject) {
      var xPos;
      console.log("gameObject.key",gameObject.key)
      if(gameObject.key == 1 || gameObject.key == 2 || gameObject.key == 3 || gameObject.key == 4) 
        xPos = this.cameras.main.width * .46;
       else 
        xPos =  gameObject.x;
      var objectRight = this.add.image(xPos,gameObject.y,g_assetsKeyJSON.RIGHT).setDepth(1500).setAlpha(1).setScale(0);
      this.animateResult(objectRight);
      this.rightWrongArr.push(objectRight);
     // this.bounceElement(gameObject.index, this.startY);
    }

    animateResult(element) {
      var fadeInText = this.tweens.add({
        targets: element,
        scale: 0.1,
        alpha: 1,
        duration: BLINK_DURATION,
        ease: "Bounce.In",
        onComplete: function () { 
        }
      });
    }

    animateYellowGlow() {
      var _self = this;
      var starPathAnim = this.tweens.add({
        targets: this.uiElement.yellowGlow,
        yoyo:true,
        alpha:1,
        duration: 500,
        ease: "Power",
        onComplete: function () {
        }
      });
    }




}

export default LevelTwo;
