export default class TweenManager extends Phaser.GameObjects.GameObject {

    constructor(scene) {
        super(scene,"");
        this.scene = scene;
        console.log("thisinTween",this)
    }

    setProperties(object,properties) {
        let xPos,alpha,scale,yPos,ease,repeat,duration,callbackFun;
        (properties.hasOwnProperty('x')) 
                                        ?  xPos = properties.x * this.scene.cameras.main.width
                                        :  xPos = object.x;

        (properties.hasOwnProperty('y')) 
                                        ?  yPos = properties.y *  this.scene.cameras.main.height
                                        :  yPos = object.y;

        (properties.hasOwnProperty('alpha')) 
                                        ?  alpha = properties.alpha 
                                        :  alpha = object.alpha;

        (properties.hasOwnProperty('scale')) 
                                        ?  scale = properties.scale 
                                        :  scale = object.scale;

        (properties.hasOwnProperty('ease')) 
                                        ? ease = properties.ease 
                                        : ease = "linear";

        (properties.hasOwnProperty('repeat')) 
                                        ? repeat = properties.repeat 
                                        : repeat = null;

        (properties.hasOwnProperty('duration')) 
                                        ? duration = properties.duration 
                                        : duration = 1000;

        (properties.hasOwnProperty('callbackFun')) 
                                        ? callbackFun = properties.callbackFun 
                                        : callbackFun = null; 

        var _self = this;

       var tweenObject = this.scene.tweens.add({
            targets:object,
            x:xPos,
            y:yPos,
            alpha:alpha,
            scale:scale,
            ease:ease,
            repeat:repeat,
            duration:duration,
            callback: function() {
               if(callbackFun !== null) {
                   callbackFun();
               }
            }
        });

        return tweenObject;
    }


}