
class audioManager extends Phaser.GameObjects.Container {

    constructor(scene) {
        super(scene,0,0);
        this.scene = scene;
        this.scene.add.existing(this);
        this.playBgMus = false;
    }

    playBgMusic(){ 
        if(this.playBgMus !== true) {
        this.bgMusic = new Howl({
            src: "assets/audio/POL-follow-me-short.mp3",
            loop: true
        });
        this.bgMusic.volume(.15)
        this.bgMusic.play();   
        this.playBgMus = true;
        } 
    }

    pauseBgMusic() {
        this.bgMusic.pause();
    }

    resumeBgMusic() {
        this.bgMusic.playing() ? console.log("dont play"): this.bgMusic.play();
    }

    playJumpSFX() {
        let jumpSFX = new Howl({
            src: "assets/audio/jump.mp3"
        });
        jumpSFX.play();
    }

    playCollectObj() {
        let collectSFX = new Howl({
            src: "assets/audio/generalcollision.mp3"
        });
        collectSFX.play();
    }

    playDangerCollision() {  
        let dangerSFX = new Howl({
            src: "assets/audio/dangercollision.mp3"
        });
        dangerSFX.play();
    }

    playClickSFX() {
        let clickSFX = new Howl({
            src: "assets/audio/click.mp3"
        });
        clickSFX.play();
    }

    playLevelCompleteSFX() {
        let levelCompleteSFX = new Howl({
            src: "assets/audio/levelcomplete.mp3"
        });
        levelCompleteSFX.play();
    }

    playBonusCollective(){
        let bonusSFX = new Howl({
            src: "assets/audio/bonusCollected.mp3"
        });
        bonusSFX.play();
    }

    playTimeUp(){
        let timeUpSFX = new Howl({
            src: "assets/audio/timeup.mp3"
        });
        timeUpSFX.play();
    }

    playIntroSFX(){
        let playIntroSFX = new Howl({
            src: "assets/audio/Intro.mp3"
        });
        playIntroSFX.play();
    }

    playLevelCompleteSFX(){
        let playscoreboardSFX = new Howl({
            src: "assets/audio/levelcomplete.mp3"
        });
        playscoreboardSFX.play();
    }

    stopBgMusic(){
        this.playBgMus = false;
        this.bgMusic.stop();
    }
}


export default audioManager;